/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.Assertion;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.operation.DatabaseOperation;

public class DBUnitService {

	private Connection connection;

	private boolean setSchema = false;

	private Log log;

	public DBUnitService(Connection connection, boolean setSchema) {
		super();
		this.connection = connection;
		this.setSchema = setSchema;
		log = LogFactory.getLog(this.getClass());
	}

	public IDatabaseConnection getIDatabaseConnection() throws Exception {
		// DbUnit用のコネクションを作成
		IDatabaseConnection con;
		if (setSchema) {
			con = new DatabaseConnection(connection, connection.getMetaData()
					.getUserName());
		} else {
			con = new DatabaseConnection(connection);
		}
		return con;
	}

	public void export(String[] tables, String path) throws Exception {
		// DBUnit用のコネクションの作成
		IDatabaseConnection con = getIDatabaseConnection();
		// 指定したテーブルのみのExport
		IDataSet userDataSet = con.createDataSet(tables);
		XlsDataSet.write(userDataSet, new FileOutputStream(path));
	}

	public void importDB(String path) throws Exception {
		IDatabaseConnection con = getIDatabaseConnection();
		IDataSet userDataSet = new XlsDataSet(new FileInputStream(path));
		DatabaseConfig config = con.getConfig();
		config.setFeature("http://www.dbunit.org/features/batchedStatements",
				true);
		DatabaseOperation.CLEAN_INSERT.execute(con, userDataSet);
		// シーケンスの設定
		// resetVal("seq_Memorandum_id");
		log.info(path + "テストデータ・インポート完了");

	}

	public void assertDB(String[] tables, String path) throws Exception {
		IDatabaseConnection con = getIDatabaseConnection();
		IDataSet dsTbs = con.createDataSet(tables);
		IDataSet dsXls = new XlsDataSet(new FileInputStream(path));
		Assertion.assertEquals(dsXls, dsTbs);
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < tables.length; i++) {
			sb.append(tables[i]).append("/");
		}
		log.info("tables:" + sb.toString() + " : assert OK!");
	}

}
