/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import jp.co.kpscorp.meema.engine.plugin.Plugin;
import jp.co.kpscorp.meema.util.Service;
import jp.co.kpscorp.meema.util.Util;
import junit.framework.Assert;
import junit.framework.TestCase;

/**
 * <strong>自動生成されたコードを実行する。 </strong>
 * <p>
 * 
 * @author Katsusuke 作成日:2005/06/10
 */
public class TestServiceTest extends TestServiceSuper {

	protected Service service = new Service();

	/**
	 * @param tc
	 *            実行する環境のTestCaseクラスのインスタンス
	 * @param packageName
	 *            実行するテストクラスのパッケージ名
	 */
	public TestServiceTest(String packageName) {
		setPackageName(packageName);
	}

	/**
	 * テストコードを実行する
	 * 
	 * @param o
	 * @param sufix
	 * @throws Exception
	 * @see jp.co.kpscorp.commontools.TestServiceSuper#exec(java.lang.Object,
	 *      java.lang.String)
	 */
	public void exec(Object o, String sufix) throws Exception {
		String className = packageName + ".Test" + o.getClass().getSimpleName()
				+ sufix;
		TestCase sub;
		try {
			sub = (TestCase) Class.forName(className).newInstance();
		} catch (ClassNotFoundException e) {
			Assert.fail("テストクラス:" + className + "が見つかりません！！");
			return;
		}
		StringBuffer methodName = new StringBuffer(Util.getTestMethodName(o,
				sufix));
		Class[] c = { getExAopClass(o.getClass()) };
		Method mt;
		try {
			mt = sub.getClass().getMethod(methodName.toString(), c);
		} catch (NoSuchMethodException e) {
			Assert.fail("テストメソッド:" + methodName + "が見つかりません！！");
			return;
		}
		Object[] oa = { o };
		try {
			mt.invoke(sub, oa);
		} catch (InvocationTargetException e) {
			if (e.getCause() instanceof Error) {
				throw (Error) e.getCause();
			} else {
				throw (Exception) e.getCause();
			}
		}
	}

	private Class getExAopClass(Class c) throws ClassNotFoundException {
		String s = Util.getExAopName(c);
		return Class.forName(s);
	}

	/**
	 * ここではnullを返す
	 * 
	 * @return
	 * @see jp.co.kpscorp.commontools.TestServiceSuper#getPlugin()
	 */
	protected Plugin getPlugin() {
		return null;
	}

	public int getLineLimit() {
		return 0;
	}

	public void setLineLimit(int lineLimit) {
	}


}
