/*   Copyright 2008  KPS Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.co.kpscorp.meema.selenium;

import jp.co.kpscorp.meema.service.TestServiceCode;

import com.thoughtworks.selenium.Selenium;

/**
 * <strong> SeleniumAssertのAssertクラス生成用の実装。</strong>
 * <p>
 * 
 * @author katsusuke
 * 
 */
public class SeleniumAssertGen extends SeleniumAssertBase {

	/**
	 * @param selenium
	 * @param srcPath
	 * @param packageName
	 */
	public SeleniumAssertGen(Selenium selenium, String srcPath,
			String packageName) {
		super();
		tester = new SeleniumTester(selenium);
		setMakeHtml(true);
		ts = new TestServiceCode(srcPath, packageName);
	}

	/**
	 * @param selenium
	 * @param srcPath
	 * @param packageName
	 * @param encode
	 */
	public SeleniumAssertGen(Selenium selenium, String srcPath,
			String packageName, String encode) {
		tester = new SeleniumTester(selenium);
		setMakeHtml(true);
		ts = new TestServiceCode(srcPath, packageName, encode);
	}

}
