/*
 * Decompiled with CFR 0.152.
 */
package mediacollage.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mediacollage.core.AbstractObject;
import mediacollage.core.Binding;
import mediacollage.core.BindingList;
import mediacollage.core.BindingSelf;
import mediacollage.core.SelectionCode;
import mediacollage.core.Tools;
import mediacollage.swingui.AOBindingBoxList;
import mediacollage.swingui.Editor;

public class AOView
extends JInternalFrame
implements Observer {
    static int openFrameCount = 0;
    static final int xOffset = 30;
    static final int yOffset = 30;
    Editor editor;
    JInternalFrame frame;
    Container cont;
    AbstractObject object;
    JLabel objectView;
    AOBindingBoxList bindingBoxList;
    boolean selecting = true;
    public static final int LINE_WIDTH = 2;
    protected Point start = new Point(0, 0);
    protected Point finish = new Point(0, 0);
    protected Point pastePoint;
    SelectionCode code;
    JPopupMenu popup;

    public AOView(AbstractObject ao, Editor editor) throws HeadlessException {
        super("AOView", true, true, true, true);
        this.frame = this;
        this.editor = editor;
        this.object = ao;
        this.createPopupMenu(this.object.getSelectorList());
        ao.addObserver(this);
        this.cont = this.getContentPane();
        this.cont.setBackground(Color.black);
        this.cont.setLayout(new BorderLayout());
        this.bindingBoxList = new AOBindingBoxList(this.object, this);
        this.cont.add((Component)this.bindingBoxList, "First");
        this.addObjectView(ao.getConcreteObject().getImageIcon());
        this.setVisible(true);
    }

    public static AOView makeAOView(String title, AbstractObject ao, Editor editor) throws HeadlessException {
        AOView aov = new AOView(ao, editor);
        aov.setTitle(title);
        aov.add(ao);
        return aov;
    }

    public void add(AbstractObject ao) {
        this.object = ao;
        ImageIcon objectIcon = ao.getConcreteObject().getImageIcon();
        this.addObjectView(objectIcon);
        BindingList blist = ao.getBindingList();
        this.addBindingList(blist);
        this.pack();
    }

    public void addBindingList(BindingList blist) {
        if (this.bindingBoxList == null) {
            this.bindingBoxList = new AOBindingBoxList(this.object, this);
            this.cont.add((Component)this.bindingBoxList, "First");
        }
        this.bindingBoxList.addBindingList(blist);
    }

    public void addBinding(Binding b) {
        this.object.addBinding(b);
        this.bindingBoxList.addBinding(b);
    }

    private void addObjectView(ImageIcon icon) {
        this.objectView = new JLabel(icon);
        this.objectView.setHorizontalAlignment(2);
        this.objectView.setVerticalAlignment(1);
        this.objectView.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                AOView.this.handleMouseDown(event);
            }
        });
        this.objectView.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent event) {
                AOView.this.handleMouseDrag(event);
            }
        });
        this.cont.add(this.objectView);
    }

    protected Image shadeoutSelection(Rectangle area, Color cc) {
        ImageIcon ii = this.object.getConcreteObject().getImageIcon();
        if (ii.getImage() == null) {
            return new ImageIcon().getImage();
        }
        Image image = ii.getImage();
        int imageWidth = ii.getIconWidth();
        int imageHeight = ii.getIconHeight();
        int[] imagePixels = new int[area.width * area.height];
        int c = cc.getRGB();
        int[] oldPixels = Tools.getPixels(image, 0, 0, imageWidth, imageHeight);
        int y = 0;
        while (y < area.height) {
            if (imageHeight <= area.y + y) break;
            int x = 0;
            while (x < area.width) {
                if (imageWidth <= area.x + x) break;
                imagePixels[y * area.width + x] = oldPixels[(area.y + y) * imageWidth + area.x + x];
                oldPixels[(area.y + y) * imageWidth + area.x + x] = c;
                ++x;
            }
            ++y;
        }
        ii.setImage(Tools.createImageFromPixels(oldPixels, imageWidth, imageHeight));
        this.objectView.setIcon(ii);
        return Tools.createImageFromPixels(imagePixels, area.width, area.height);
    }

    public AbstractObject getAbstractObject() {
        return this.object;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public ImageIcon getObjectIcon() {
        return this.object.getConcreteObject().getImageIcon();
    }

    public void setObjectIcon(ImageIcon iic) {
        this.objectView.setIcon(iic);
        this.objectView.setBounds(0, 0, iic.getIconWidth(), iic.getIconHeight());
        this.pack();
        this.revalidate();
    }

    private boolean onSelecting() {
        this.selecting = true;
        return this.selecting;
    }

    private boolean offSelecting() {
        this.selecting = false;
        return this.selecting;
    }

    protected void handleMouseDown(MouseEvent event) {
        if ((event.getModifiers() & 0x10) != 0) {
            this.start = event.getPoint();
            this.finish = event.getPoint();
        } else if ((event.getModifiers() & 4) != 0) {
            int width = this.finish.x - this.start.x;
            int height = this.finish.y - this.start.y;
            this.code = new SelectionCode(this.start.x, this.start.y, width, height);
            this.popup.show(this.cont, event.getX(), event.getY());
            this.offSelecting();
            this.repaint();
        }
    }

    protected void handleMouseDrag(MouseEvent event) {
        this.finish = event.getPoint();
        this.frame.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.selecting) {
            int width = this.finish.x - this.start.x;
            int height = this.finish.y - this.start.y;
            if (width > 0 && height > 0) {
                g.setColor(Color.blue);
                int i = 0;
                while (i < 2) {
                    g.drawRect(this.objectView.getX() + this.start.x + i + 4, this.objectView.getY() + this.start.y + 28, width, height);
                    ++i;
                }
            }
        } else {
            this.onSelecting();
        }
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof BindingSelf) {
            BindingSelf b = (BindingSelf)arg;
            this.setObjectIcon(Tools.copyImageIcon(b.getSubObject().getImageIcon()));
            this.bindingBoxList.resetBindingList();
        } else if (arg instanceof AbstractObject || arg instanceof Binding) {
            // empty if block
        }
        this.pack();
        this.revalidate();
        this.toFront();
    }

    public void createPopupMenu(String[] selectorList) {
        PopupMenuListener pml = new PopupMenuListener();
        this.popup = new JPopupMenu();
        int i = 0;
        while (i < selectorList.length) {
            this.addPopupMenuItem(selectorList[i], selectorList[i], pml);
            ++i;
        }
    }

    private void addPopupMenuItem(String label, String command, ActionListener pml) {
        JMenuItem menuItem = new JMenuItem(label);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(pml);
        this.popup.add(menuItem);
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AOView.this.object.addBinding(new Binding(e.getActionCommand(), AOView.this.code, AOView.this.object));
            AOView.this.offSelecting();
            AOView.this.repaint();
        }
    }
}

