package jp.sourceforge.medaka.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import jp.sourceforge.medaka.Activator;

/**
 * Class used to initialize default preference values for medaka.
 * @author G.sukigara
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	/**
	 * lݒ 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        
        store.setDefault(PreferenceConstants.IS_DEBUG, false);
        
		store.setDefault(PreferenceConstants.CMD_1, "notepad %FILE_PATH%");
		store.setDefault(PreferenceConstants.CMD_2, "");
		store.setDefault(PreferenceConstants.CMD_3, "calc");
		store.setDefault(PreferenceConstants.CMD_4, "cmd /k java  %JAVA_PATH%");
		store.setDefault(PreferenceConstants.CMD_5, "cmd /k start /D %DIR_PATH% cmd /k java %JAVA_PATH%");
		store.setDefault(PreferenceConstants.CMD_6, "explorer.exe /e,/select, %FILE_PATH%");
		store.setDefault(PreferenceConstants.CMD_7, "cmd /k start /D %DIR_PATH% dir");
		store.setDefault(PreferenceConstants.CMD_8, "dir");
		store.setDefault(PreferenceConstants.CMD_9, "");
        store.setDefault(PreferenceConstants.CMD_0, "");

	}
}
