package jp.sourceforge.medaka.preferences;

import jp.sourceforge.medaka.Activator;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


/**
 * ߂ݒ
 * @author G.sukigara
 */
public class MedakaPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    /**
     * 񂷂Ƃ炭I
     */
    public MedakaPreferencePage() {
        super(GRID);
        setPreferenceStore(Activator.getDefault().getPreferenceStore());
        setDescription(
                "%JAVA_PATH%\t Javat@C̃pXipbP[W܂ށj\r\n"
                + "%FILE_PATH%\t t@C̃tpX\r\n"
                + "%FILE_PATH_NOESC%\t t@C̃tpX(Oオ\"ň͂܂Ȃ)\r\n"
                + "%FILE_NAME%\t t@C\r\n"
                + "%BASE_NAME%\t t@C(gq)\r\n"
                
                + "%DIR_PATH%\t fBNg̃tpX\r\n"
                + "%DIR_PATH_NOESC%\t fBNg̃tpX(Oオ\"ň͂܂Ȃ)\r\n"
                + "%DIR_NAME%\t fBNg\r\n"
                );
    }

    /**
     * eݒ荀ڂ̍쐬
     */
    public void createFieldEditors() {
        addField(new BooleanFieldEditor(PreferenceConstants.IS_DEBUG ,
                "fobO[h", getFieldEditorParent()));
        createEditorSet("1");
        createEditorSet("2");
        createEditorSet("3");
        createEditorSet("4");
        createEditorSet("5");
        createEditorSet("6");
        createEditorSet("7");
        createEditorSet("8");
        createEditorSet("9");
        createEditorSet("0");
    }

    /**
     * ڃZbg̍쐬B
     */
    private void createEditorSet(String memNo) {
        Group homeGroup = new Group(getFieldEditorParent(), SWT.NONE);
        homeGroup.setText("CTRL+SHIFT+" + memNo);
        addField(new StringFieldEditor("CMD_" + memNo, "R}h", homeGroup));
        //addField(new StringFieldEditor("DISP_" + memNo, "\", homeGroup));
        initLayoutAndData(homeGroup, 2);
        new Label(getFieldEditorParent(), SWT.NULL);
    }
    
    /**
     * ڏ
     */
    private void initLayoutAndData(Composite aGroup, int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        aGroup.setLayout(gl);
        GridData gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 1;
        gd.verticalAlignment = SWT.FILL;
        gd.widthHint = 400;
        aGroup.setLayoutData(gd);
    }

    /**
     * Init
     */
    public void init(IWorkbench workbench) {
    }
}