package jp.sourceforge.medaka.actions;

import java.io.File;

import jp.sourceforge.medaka.Activator;
import jp.sourceforge.medaka.MessageException;
import jp.sourceforge.medaka.preferences.PreferenceConstants;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;


/**
 * ߂񂷁[ς炷
 * 
 * @author G.Sukigara
 */
public abstract class AbstractMedakaAction implements IWorkbenchWindowActionDelegate {

	/** IĂ */
    private Object selected = null;

    /** ǂ */
    private IWorkbenchWindow workbenchWindow = null;

    /**
     * t@CJs
     * 
     * @param action action
     */
    public void run(IAction action) {

        if (selected == null) {
            MessageDialog.openError(new Shell(), "Medaka",
                    "IĂȂ񂾂Ȃ");
            return;
        }

        try {
            String command = getCommand();
            Runtime.getRuntime().exec(command);
        } catch (MessageException me) {
            MessageDialog.openError(new Shell(), "Medaka",
                    me.getMessage());
        } catch (Throwable th) {
            MessageDialog.openError(new Shell(), "Medaka",
                    "߂񂾂Ȃ@sȂ\n" + th);
            th.printStackTrace();
        }
    }

    private String getCommand() throws MessageException {
        String command = doAction();
        if (command == null | command.length() == 0){
            throw new MessageException("R}hݒ肳Ă܂B\r\n" +
                    "uEChEvˁuݒvR}hݒ肵ĂB");
        }
        
        if (getBooleanProperty(PreferenceConstants.IS_DEBUG)) {
            InputDialog in = new InputDialog(new Shell(), "Medaka -DEBUG Mode-",
                    "ȉR}hs܂", command , null);
            int ret = in.open();
            if (ret == 1){
                throw new MessageException("LZ܂B");
            }
        }
        return command;
    }
    
    
    /**
     * ANṼR}hԋpB ̂߂ǂ邱ƁB
     * @return String sR}h
     * @throws Exception G[
     */
    protected abstract String doAction() throws MessageException;

    /**
     * t@C擾B
     * @return File IĂt@CFileNX
     */
    private File getFile() {
        File directory = null;
        if (selected instanceof IResource) {
            directory = new File(((IResource) selected).getLocation()
                    .toOSString());
        } else if (selected instanceof File) {
            directory = (File) selected;
        }
        return directory;
    }
    
    /**
     * t@CtpX̕\L擾B
     * @return t@CtpX̕\L
     */
    private String getFilePathString() {
        return getFile().toString().replace("\\", "\\\\");
    }

    /**
     * t@C擾
     */
    private String getFileNameString() throws MessageException {
        File file = getFile();
        if (!file.isFile()) {
            throw new MessageException("t@CIĂ܂B");
        }
        return file.getName();
    }

    /**
     * fBNg擾
     * @return
     */
    private String getDirNameSting() {
        File file = getFile();
        if (!file.isDirectory()) {
            return file.getParentFile().getName();
        } 
        return file.getName();
    }
    
    /**
     * fBNgtpX擾B
     * @return fBNg
     */
    private String getDirPathString() {
        File file = getFile();
        if (file.isFile()) {
            return file.getParent().replace("\\", "\\\\");
        } else {
            return file.toString().replace("\\", "\\\\");
        }
    }
    
    /**
     * Java\L̃tpX擾B
     * 
     * @return Java\L̃tpX
     * @throws Exception G[
     */
    private String getJavaPathString() throws MessageException{

        String javaPath = "";

        if (selected instanceof IResource) {
            IPath path = ((IResource) selected).getProjectRelativePath();
            javaPath = path.removeFileExtension().toString();
            javaPath = javaPath.replaceAll("/", ".");

            try {
            IProject project = ((IResource) selected).getProject();
            IProjectNature na = project.getNature("org.eclipse.jdt.core.javanature");

            if (na instanceof JavaProject) {
                JavaProject javaProject = (JavaProject)na;
                    
                IPackageFragmentRoot[] pkgRoot = javaProject.getPackageFragmentRoots();
                for (int i = 0; i < pkgRoot.length; i++) {
                    IPackageFragmentRoot root = pkgRoot[i];
                    if (root.getKind() == IPackageFragmentRoot.K_SOURCE) {
                        // \[XzufBNg̏ꍇB
                        String fragmentName = root.getElementName();
                        if (javaPath.startsWith(fragmentName)) {
                            javaPath = javaPath.replaceFirst(fragmentName + "\\.", "");
                        }
                    }
                }
            } else {
                throw new MessageException("javat@CIĂ܂B");
            }
            
            } catch (CoreException ce ) {
                throw new MessageException("Javat@C̃tpX擾ɃG[܂B", ce);
            }
        } else {
            throw new MessageException("\[XIĂ܂B");
        }
        return javaPath;

    }

    /**
     * IύXɌ݊JĂt@C擾B
     * 
     * GNXv[[ʂ̏ꍇ̓ZNV擾B GfB^̏ꍇWindow擾B
     * 
     * @param action action
     * @param selection IĂ
     */
    public void selectionChanged(IAction action, ISelection selection) {

        IAdaptable adaptable = null;
        if (selection instanceof IStructuredSelection) {
            adaptable = (IAdaptable) ((IStructuredSelection) selection)
                    .getFirstElement();
            if (adaptable instanceof IResource) {
                this.selected = (IResource) adaptable;
            } else {
                this.selected = (IResource) adaptable
                        .getAdapter(IResource.class);
            }
        } else {
            adaptable = (IAdaptable) workbenchWindow.getActivePage()
                    .getActiveEditor().getEditorInput().getAdapter(
                            IResource.class);
            selected = (IResource) adaptable.getAdapter(IResource.class);
        }
    }

    /**
     * 
     */
    public void dispose() {
        // NOP
    }

    /**
     * ͗Ă
     * 
     * @param window ǂ
     */
    public void init(IWorkbenchWindow window) {

    	workbenchWindow = window;
        selected = null;
        IAdaptable adaptable = null;

        ISelection selection = workbenchWindow.getSelectionService()
                .getSelection();
        if (selection instanceof IStructuredSelection) {
            adaptable = (IAdaptable) ((IStructuredSelection) selection)
                    .getFirstElement();
            if (adaptable instanceof IResource) {
                this.selected = (IResource) adaptable;
            } else {
                this.selected = (IResource) adaptable
                        .getAdapter(IResource.class);
            }
        } else {
            adaptable = (IAdaptable) workbenchWindow.getActivePage()
                    .getActiveEditor().getEditorInput().getAdapter(
                            IResource.class);
            selected = (IResource) adaptable.getAdapter(IResource.class);
        }
    }
    
    /**
     * ɋLqꂽJavapXȂǂuB
     * @param arg Ђ
     * @return uꂽ
     */
    protected String editArgments(String arg) throws MessageException{
        String des = arg;
        des = des.replaceAll("%JAVA_PATH%", getJavaPathString());
        
        des = des.replaceAll("%FILE_PATH%", escPath(getFilePathString()));
        des = des.replaceAll("%FILE_PATH_NOESC%", getFilePathString());
        des = des.replaceAll("%FILE_NAME%", escPath(getFileNameString()));
        des = des.replaceAll("%BASE_NAME%", getBaseNameString());
        
        des = des.replaceAll("%DIR_PATH%", escPath(getDirPathString()));
        des = des.replaceAll("%DIR_PATH_NOESC%", getDirPathString());
        des = des.replaceAll("%DIR_NAME%", getDirNameSting());
        
        return des;
    }
    
    /**
     * t@Cigqj̎擾
     * @return
     */
    private String getBaseNameString() throws MessageException{
        String baseName = getFileNameString();
        if (baseName.lastIndexOf(".") > 0) {
            baseName = baseName.substring(0, baseName.lastIndexOf("."));
        }
        return baseName;
    }

    /**
     * pXɋ󔒂Ă鎞ׂ̈Ɂu"vŊ
     * @param path
     * @return
     */
    private String escPath(String path) {
        return "\"" + path + "\"";
    }
    
    /**
     * Storeɕۑꂽݒ擾
     * @param id ݒL[
     * @return ݒe
     */
    protected String getProperty(String id) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString(id);
    }
    
    /**
     * StoreɕۑꂽBooleanݒ擾
     * @param id ݒL[
     * @return ݒe
     */
    protected boolean getBooleanProperty(String id) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean(id);
    }

    
}
