/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t superblock();
const commandtable_t command_super_block =
	{"super_block", superblock, "[address]", "print super_block table"};

addr_t super_blocks_addr;

extern addr_t print_superblock();

PRIVATE addr_t
superblock()
{
	int i, c, full = 0;
	struct list_head super_blocks;
	addr_t addr = 0;
	extern void prhead_superblock();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	prhead_superblock();

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_superblock(addr, full);
		}
	} else {
		GETADDR(super_blocks);
		memread(super_blocks_addr, sizeof(super_blocks), &super_blocks,
			"super_blocks");
		for (addr = (addr_t)super_blocks.next; addr && addr != super_blocks_addr;) {
			addr = print_superblock(addr, full);
		}
	}
	return addr;
}
