/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t semaphore();
const commandtable_t command_semaphore =
	{"semaphore", semaphore, "address", "print semaphore table"};

extern void prhead_semaphore();
extern int print_semaphore();

PRIVATE addr_t
semaphore()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	if (optind == argcnt) {
		THROW(usage);
	}

	prhead_semaphore();
	while (args[optind]) {
		print_semaphore(getaddr(args[optind]));
		optind++;
	}
	return 0;
}
