/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t vm_struct();
const commandtable_t command_vm_struct =
	{"vm_struct", vm_struct, "[address]", "dump vm_struct table"};

extern addr_t print_vm_struct();
addr_t vmlist_addr;

PRIVATE addr_t
vm_struct()
{
	int i, c;
	addr_t addr = 0;
	extern void prhead_vm_struct();

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		prhead_vm_struct();
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_vm_struct(addr);
		}
		return addr;
	}

	GETADDR(vmlist);

	memread(vmlist_addr, sizeof(addr), &addr, "vmlist");
	prhead_vm_struct();
	while (addr) {
		addr = print_vm_struct(addr);
	}
	return addr;
}
