/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

#if 0
#include <linux/types.h>
#include <linux/kdev_t.h>
#endif

/* begin include/linux/lvm.h */
#define	ABS_MAX_VG	99
/* end include/linux/lvm.h */

PRIVATE addr_t vg();
PRIVATE addr_t pv();
PRIVATE addr_t lv();
const commandtable_t
	command_vg = {"vg", vg, "[-f] [address|slot]", "print vg_t table"},
	command_pv = {"pv", pv, "address", "print pv_t table"},
	command_lv = {"lv", lv, "address", "print lv_t table"};

addr_t vg_addr;

extern void prhead_vg();
extern addr_t print_vg();
extern addr_t print_pv();
extern addr_t print_lv();

PRIVATE addr_t
vg()
{
	int i, c;
	int full = 0;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	GETADDR(vg);

	if (argcnt > optind) {
		if (!full) prhead_vg();
		for (i = optind; i < argcnt; i++) {
			addr = print_vg(getaddr(args[i]), full);
		}
	} else {
		if (!full) prhead_vg();
		for (i = 0; i < ABS_MAX_VG; i++) {
			addr = print_vg((addr_t)i, full);
		}
	}
	return addr;
}

PRIVATE addr_t
pv()
{
	int i, c;
	int full = 0;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_pv(addr, full);
		}
	} else {
		THROW(usage);
	}
	return addr;
}

PRIVATE addr_t
lv()
{
	int i, c;
	int full = 0;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_lv(addr, full);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
