/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include <asm/types.h>
#include <linux/ext2_fs_i.h>
#include "crash.h"

PRIVATE addr_t ext2_inode_info();
const commandtable_t command_ext2_inode_info =
	{"ext2_inode_info", ext2_inode_info, "address", "print ext2_inode_info table"};

void
print_ext2_inode_info(addr)
	addr_t addr;
{
	struct ext2_inode_info e2i;
	int i;

	memread(addr, sizeof(e2i), &e2i, "ext2_inode_info");
	mprintf("data:");
	for (i = 0; i < LENGTHOF(e2i.i_data); i++) {
		mprintf(" %8x", e2i.i_data[i]);
		if (i == 7) {
			mprintf("\n     ");
		}
	}
	mprintf("\n");
	mprintf("flags:            %08x\n", e2i.i_flags);
	mprintf("faddr:            %08x\n", e2i.i_faddr);
	mprintf("frag_no:                %02x\n", e2i.i_frag_no);
	mprintf("frag_size:              %02x\n", e2i.i_frag_size);
#if SUBLEVEL<18 /*SUBLEVEL<19*/ /*XXX*/
	/*
	 * The `i_osync' member exists at stock Linux-2.4.18,
	 * and does not exist at 2.4.19-pre*.
	 * But Red Hat Kernel (2.4.18-*) dropped this member,
	 * so mcrash for 2.4.18 does not include it.
	 */
	mprintf("osync:                %04x\n", e2i.i_osync);
#endif
	mprintf("file_acl:         %08x\n", e2i.i_file_acl);
	mprintf("dir_acl:          %08x\n", e2i.i_dir_acl);
	mprintf("dtime:            %08x\n", e2i.i_dtime);
	mprintf("block_group:      %08x\n", e2i.i_block_group);
	mprintf("next_alloc_block: %08x\n", e2i.i_next_alloc_block);
	mprintf("next_alloc_goal:  %08x\n", e2i.i_next_alloc_goal);
	mprintf("prealloc_block:   %08x\n", e2i.i_prealloc_block);
	mprintf("prealloc_count:   %08x\n", e2i.i_prealloc_count);
#if SUBLEVEL<7
	mprintf("high_size:        %08x\n", e2i.i_high_size);
#endif
#if SUBLEVEL>=10
	mprintf("dir_start_lookup: %08x\n", e2i.i_dir_start_lookup);
#endif
	mprintf("new_inode:        %08x\n", e2i.i_new_inode);
}

PRIVATE addr_t
ext2_inode_info()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		print_ext2_inode_info(getaddr(args[optind]));
		optind++;
	}
	return 0;
}
