/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>
#include <xfs_inum.h>
#include <xfs_sb.h>
#include <xfs_log.h>
#include <xfs_trans.h>
#include <xfs_dir.h>
#include <xfs_dmapi.h>
#include <xfs_mount.h>
#include <xfs_log_priv.h>

#include "flags_log_priv.h"

addr_t
print_xlog(addr)
	addr_t addr;
{
	xlog_t log;
	static const struct bitname lflags[] = {
		{ XLOG_CHKSUM_MISMATCH, "chksum_mismatch" },
		{ XLOG_ACTIVE_RECOVERY, "active_recovery" },
		{ XLOG_RECOVERY_NEEDED, "recovery_needed" },
		{ XLOG_IO_ERROR,	"io_error" },
		{ 0,			NULL }
	};

	mprintf("addr           " FPTR "  (%x)\n", addr, sizeof(log));
	memread(addr, sizeof(log), &log, "xlog_t");

	mprintf("flushcnt       %x\n", log.l_flushcnt);
	mprintf("ticket_cnt     %x\n", log.l_ticket_cnt);
	mprintf("ticket_tcnt    %x\n", log.l_ticket_tcnt);
	mprintf("covered_state  %x\n", log.l_covered_state);
	mprintf("freelist       " FPTR "  (xlog_ticket)\n", log.l_freelist);
	mprintf("unmount_free   " FPTR "  (xlog_ticket)\n", log.l_unmount_free);
	mprintf("tail           " FPTR "  (xlog_ticket)\n", log.l_tail);
	mprintf("iclog          " FPTR "  (xlog_in_core)\n", log.l_iclog);
	mprintf("tail_lsn       %lx\n", log.l_tail_lsn);
	mprintf("last_sync_lsn  %lx\n", log.l_last_sync_lsn);
	mprintf("mp             " FPTR "  (xfs_mount)\n", log.l_mp);
	mprintf("xbuf           " FPTR "  (page_buf)\n", log.l_xbuf);
	mprintf("logBBstart     %lx\n", log.l_logBBstart);
	mprintf("logsize        %x\n", log.l_logsize);
	mprintf("logBBsize      %x\n", log.l_logBBsize);
#ifdef _log_has_l_roundoff
	mprintf("roundoff       %x\n", log.l_roundoff);
#endif
	mprintf("curr_cycle     %x\n", log.l_curr_cycle);
	mprintf("prev_cycle     %x\n", log.l_prev_cycle);
	mprintf("curr_block     %x\n", log.l_curr_block);
	mprintf("prev_block     %x\n", log.l_prev_block);
	mprintf("iclog_size     %x  (2^%d)\n", log.l_iclog_size,
		log.l_iclog_size_log);
	mprintf("iclog_bufs     %x\n", log.l_iclog_bufs);
	mprintf("reserve_headq  " FPTR "  (xlog_ticket)\n", log.l_reserve_headq);
	mprintf("write_headq    " FPTR "  (xlog_ticket)\n", log.l_write_headq);
	mprintf("grant_reserve  %x  %x\n",
		log.l_grant_reserve_cycle,
		log.l_grant_reserve_bytes);
	mprintf("grant_write    %x  %x\n",
		log.l_grant_write_cycle,
		log.l_grant_write_bytes);
	mprintf("flags          %x  ", log.l_flags);
	mprintbit(lflags, log.l_flags);
	mprintf("\n");

	return 0;
}

void
prhead_xlog_ticket()
{
	mprintf(SPTR"      TID CURR_RES UNIT_RES OC  C ID FLAGS\n", "ADDR");
}

addr_t
print_xlog_ticket(addr)
	addr_t addr;
{
	xlog_ticket_t ticket;
	static const struct bitname tflags[] = {
		{ XLOG_TIC_INITED,	"inited" },
		{ XLOG_TIC_PERM_RESERV,	"perm_reserv" },
		{ XLOG_TIC_IN_Q,	"in_q" },
		{ 0,			NULL }
	};

	mprintf(FPTR " ", addr);
	memread(addr, sizeof(ticket), &ticket, "xlog_ticket_t");
	mprintf("%8x %8x %8x %2x %2x %2x",
		ticket.t_tid, ticket.t_curr_res, ticket.t_unit_res,
		ticket.t_ocnt, ticket.t_cnt, ticket.t_clientid);
	mprintbit(tflags, ticket.t_flags);
	mprintf("\n");

	return (addr_t)ticket.t_next;
}

void
prhead_xlog_in_core()
{
	mprintf(SPTR" "SPTR" "SPTR" "SPTR" SIZE OFFS RCNT  BWC "SPTR" STATE\n",
		"ADDR", "BP", "LOG", "CALLBACK", "DATA");
}

addr_t
print_xlog_in_core(addr, flags)
	addr_t addr;
{
	xlog_in_core_t xic;
	static const struct bitname state[] = {
		{ XLOG_STATE_ACTIVE,	"active" },
		{ XLOG_STATE_WANT_SYNC,	"wait_sync" },
		{ XLOG_STATE_SYNCING,	"syncing" },
		{ XLOG_STATE_DONE_SYNC,	"done_sync" },
		{ XLOG_STATE_DO_CALLBACK, "do_callback" },
		{ XLOG_STATE_CALLBACK,	"callback" },
		{ XLOG_STATE_DIRTY,	"dirty" },
		{ XLOG_STATE_IOERROR,	"ioerror" },
		{ XLOG_STATE_NOTUSED,	"notused" },
		{ 0,			NULL }
	};

	if (flags)
		goto full;

	mprintf(FPTR " ", addr);
	memread(addr, sizeof(xic), &xic, "xlog_in_core_t");

	mprintf(FPTR " " FPTR " " FPTR " ",
		xic.ic_bp, xic.ic_log, xic.ic_callback);
	mprintf("%4x %4x %4x %4x ", xic.ic_size, xic.ic_offset, xic.ic_refcnt, xic.ic_bwritecnt);
#ifdef _xlog_in_core_has_hic_data
	mprintf(FPTR, xic.hic_data);
#endif /*_xlog_in_core_has_hic_data*/
	mprintbit(state, xic.ic_state);
	mprintf("\n");
	goto out;

 full:
	mprintf("==" FPTR "==\n", addr);
	memread(addr, sizeof(xic), &xic, "xlog_in_core_t");

	mprintf("bp       " FPTR "\n", xic.ic_bp);
	mprintf("log      " FPTR "\n", xic.ic_log);
	mprintf("callback " FPTR "\n", xic.ic_callback);
	mprintf("size      %x\n", xic.ic_size);
	mprintf("offset    %x\n", xic.ic_offset);
	mprintf("refcnt    %x\n", xic.ic_refcnt);
#ifdef _xlog_in_core_has_ic_roundoff
	mprintf("roundoff  %x\n", xic.ic_roundoff);
#endif
	mprintf("bwritecnt %x\n", xic.ic_bwritecnt);
	mprintf("state     %x  ", xic.ic_state);
	mprintbit(state, xic.ic_state);
	mprintf("\n");

#ifdef _xlog_in_core_has_hic_data
	mprintf("data     " FPTR "\n", xic.hic_data);
#endif /*_xlog_in_core_has_hic_data*/

 out:
	return (addr_t)xic.ic_next;
}
