/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

addr_t file_systems_addr;

PRIVATE addr_t filesystem();
const commandtable_t command_file_system_type =
	{"file_system_type", filesystem, "[address]", "print file_system_type table"};

extern addr_t print_file_system_type();

PRIVATE addr_t
filesystem()
{
	int i, c;
	addr_t addr;
	extern void prhead_filesystem();

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	prhead_filesystem();

	if (argcnt == optind) {
		GETADDR(file_systems);
		memread(file_systems_addr, sizeof(addr), &addr, "file_systems");
		while (addr) {
			addr = print_file_system_type(addr);
		}
	} else {
		for (i = optind; i < argcnt; i++) {
			addr = print_file_system_type(getvalue(args[i]));
		}
	}
	return addr;
}
