/*
 * Copyright (C) 2005 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t radix_tree_node();
const commandtable_t command_radix_tree_node =
	{"radix_tree_node", radix_tree_node, "address", "print radix_tree_node"};

extern addr_t print_radix_tree_node();

PRIVATE addr_t
radix_tree_node()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}

	while (args[optind]) {
		addr = print_radix_tree_node(getvalue(args[optind]));
		optind++;
	}
	return addr;
}
