/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t binfmt();
const commandtable_t command_binfmt =
	{"binfmt", binfmt, "", "print binfmt table"};

extern addr_t print_binfmt();
extern void prhead_binfmt();

addr_t formats_addr;

PRIVATE addr_t
binfmt()
{
	addr_t addr;
	int i, c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	prhead_binfmt();
	if (optind == argcnt) {
		GETADDR(formats);
		memread(formats_addr, sizeof(addr), &addr, "formats");
		while (addr) {
			addr = print_binfmt(addr);
		}
	} else {
		for (i = optind; i < argcnt; i++) {
			if (i > optind)
				mprintf("\n");
			addr = getvalue(args[i]);
			print_binfmt(addr);
		}
	}
	return 0;
}
