// DeviceContext.h cfoCXReLXgNX
#ifndef __WGC_DEVICECONTEXT__
#define __WGC_DEVICECONTEXT__

#include "wgc.h"
#include "GdiObject.h"
#include <windows.h>


_WGC_BEGIN                              // namespace wgc {

class DeviceContext
{
public:
	DeviceContext(HDC hDC);
	virtual ~DeviceContext(void);

	operator HDC(void)
	{return m_hDC;}


	void GetTextMetrics(TEXTMETRIC &rMetrics) const;
	int  GetDeviceCaps(const int nIndex) const;

	// Iy[V
	HGDIOBJ SelectObject(GdiObject &rNewObject);
	HPEN    SelectObject(GdiPen   &rNewPen);
	HFONT   SelectObject(GdiFont  &rNewFont);

	// OiF/wiF
	COLORREF GetTextColor(void) const;
	COLORREF GetBkColor  (void) const;
	COLORREF SetTextColor(const COLORREF color);
	COLORREF SetBkColor  (const COLORREF color);

	// obNOEh[h
	int GetBkMode(void);
	int SetBkMode(const int iBkMode);

	// 
	void GetCharWidth    (const UINT nFirstChar, const UINT nLastChar, LPINT lpBuffer) const;
	void GetCharWidthWide(const UINT nFirstChar, const UINT nLastChar, LPINT lpBuffer) const;

	// NbsÖ
	int GetClipBox(RECT &rRect) const;
	int SetClipRect(const RECT &rRect);
	int ClearClip(void);
	int IntersectClipRect(const RECT &rRect);
	int ExcludeClipRect  (const RECT &rRect);
	BOOL RectVisible(const RECT  &rRect ) const;
	BOOL PtVisible  (const POINT &rPoint) const;

	// hԂ
	void FillRect(const RECT &rect, HBRUSH hBrush);
	void FillSolidRect(const RECT &rect, const COLORREF color);
	void Invert(const RECT &rect);
	void Invert(HRGN hRgn);

	// `
	void DrawFocusRect(const RECT &rect);
	void DrawEdge(const RECT &rect, const UINT edge = EDGE_ETCHED, const UINT grfFlags = BF_RECT);

	void MoveToEx(const int x, const int y, LPPOINT lpPoint);
	void MoveTo(const int x, const int y);
	void LineTo(const int x, const int y);

	void Polyline(const POINT ptVertexes[], const UINT nCount);
	void Polygon (const POINT ptVertexes[], const UINT nCount);
	void PolyPolyline(const POINT ptVertexes[], const DWORD dwPolyPoints[], const DWORD dwCount);
	void PolyPolygon (const POINT ptVertexes[], const INT   dwPolyPoints[], const INT   dwCount);

	// eLXg`
	void TextOut    (const POINT          &pt, LPCTSTR lpString, const int nCount);
	void TextOut    (const POINT          &pt, const tstring_t &tstr);
	void TextOut    (const int x, const int y, LPCTSTR lpString, const int nCount);
	void TextOut    (const int x, const int y, const tstring_t &tstr);
	void TextOutWide(const POINT          &pt, LPCWSTR lpString, const int nCount);
	void TextOutWide(const POINT          &pt, const wstring_t &wstr);
	void TextOutWide(const int x, const int y, LPCWSTR lpString, const int nCount);
	void TextOutWide(const int x, const int y, const wstring_t &wstr);
	void ExtTextOut    (const POINT          &pt, const UINT fuOptions, const RECT &rect, LPCTSTR lpString, const UINT nCount, const int *lpDx = NULL);
	void ExtTextOut    (const POINT          &pt, const UINT fuOptions, const RECT &rect, const tstring_t &tstr              , const int *lpDx = NULL);
	void ExtTextOut    (const int x, const int y, const UINT fuOptions, const RECT &rect, LPCTSTR lpString, const UINT nCount, const int *lpDx = NULL);
	void ExtTextOut    (const int x, const int y, const UINT fuOptions, const RECT &rect, const tstring_t &tstr              , const int *lpDx = NULL);
	void ExtTextOutWide(const POINT          &pt, const UINT fuOptions, const RECT &rect, LPCWSTR lpString, const UINT nCount, const int *lpDx = NULL);
	void ExtTextOutWide(const POINT          &pt, const UINT fuOptions, const RECT &rect, const wstring_t &wstr              , const int *lpDx = NULL);
	void ExtTextOutWide(const int x, const int y, const UINT fuOptions, const RECT &rect, LPCWSTR lpString, const UINT nCount, const int *lpDx = NULL);
	void ExtTextOutWide(const int x, const int y, const UINT fuOptions, const RECT &rect, const wstring_t &wstr              , const int *lpDx = NULL);

	int DrawText(LPCTSTR lpString, const int nCount, RECT &rect, const UINT uFormat = DT_LEFT | DT_NOPREFIX);
	int DrawText(const tstring_t &tstr             , RECT &rect, const UINT uFormat = DT_LEFT | DT_NOPREFIX);

	void GetTextExtent(const tstring_t &tstr, SIZE &size) const;

protected:
	HDC m_hDC;

	void Delete(void);
};


// GDIIuWFNg̎IJ
class auto_SelectObject
{
public:
	auto_SelectObject(DeviceContext &dc, GdiObject &gdi);
	~auto_SelectObject(void);

private:
	DeviceContext &m_dc;
	GdiObject      m_old_object;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(auto_SelectObject)
};


////////////////////////////////////////////////////////////
// hDC

// NCAgDC
class DeviceContext_Client : public DeviceContext
{
public:
	explicit DeviceContext_Client(HWND hWnd);
	~DeviceContext_Client(void);

private:
	HWND m_hWnd;
};

// EChEDC
class DeviceContext_Window : public DeviceContext
{
public:
	explicit DeviceContext_Window(HWND hWnd);
	~DeviceContext_Window(void);

private:
	HWND m_hWnd;
};

// yCgDC
class DeviceContext_Paint : public DeviceContext
{
public:
	explicit DeviceContext_Paint(HWND hWnd, LPPAINTSTRUCT lpPaint = NULL);
	~DeviceContext_Paint(void);

private:
	HWND m_hWnd;
	PAINTSTRUCT m_ps;
};

// DC
class DeviceContext_Memory : public DeviceContext
{
public:
	explicit DeviceContext_Memory(HDC hDC);
	~DeviceContext_Memory(void);
};

// v^DC
class DeviceContext_Printer : public DeviceContext
{
public:
	explicit DeviceContext_Printer(LPCTSTR lpszDriver, LPCTSTR lpszDevice, CONST DEVMODE *lpInitData = NULL);
	~DeviceContext_Printer(void);

	int StartDoc(const DOCINFO &rDocInfo);
	int EndDoc  (void);
	int AbortDoc(void);

	int StartPage(void);
	int EndPage  (void);
};

_WGC_END                                // }

#endif // __WGC_DEVICECONTEXT__
