// array.h cIzNX
// @std::vector<> u{̔zvɋ߂NXB
// @usɃTCYwłvƈȊO͔zƂ܂ςȂB
// @Iz邽߂ɕKvŏ̋@\ĂȂARpNgŎg₷cƎvB
#ifndef __SGC_ARRAY__
#define __SGC_ARRAY__

#include "sgc.h"
#include <stddef.h>                     // size_t, NULL

_SGC_BEGIN

template<typename _Ty>
class array
{
public:
	////////////////////////////////////////////////////////////////////////////////
	// RXgNV

	// TCYwɂ鏉
	explicit array(const size_t size) : m_nSize(size), m_pBuffer(new _Ty[size])
	{
	}

	// f[^wɂ鏉
	explicit array(const _Ty *data, const size_t size) : m_nSize(size), m_pBuffer(new _Ty[size])
	{
		_assign(data, m_nSize);
	}

	// f[^ɂ鏉
	explicit array(const _Ty &datum, const size_t size) : m_nSize(size), m_pBuffer(new _Ty[size])
	{
		_assign(datum, m_nSize);
	}

	// Rs[RXgN^
	array(const array &rhs) : m_nSize(rhs.m_nSize), m_pBuffer(new _Ty[rhs.m_nSize])
	{
		_assign(rhs.m_pBuffer, m_nSize);
	}

	// fXgN^
	~array(void)
	{
		delete []m_pBuffer;
	}

	// Zq
	const array &operator =(const array &rhs)
	{
		// TCYȂΗOX[
		if(m_nSize != rhs.m_nSize)
		{
			throw SGCEXP_SIZE_MISMATCH;
		}
		_assign(rhs.m_pBuffer, m_nSize);
		return *this;
	}


	////////////////////////////////////////////////////////////////////////////////
	// Agr[g

	// TCY擾
	size_t size(void) const { return m_nSize; }


	////////////////////////////////////////////////////////////////////////////////
	// Zq

	// ̃LXgZqɂ{̔ẑ悤ɐ擪AhX擾łAoperator []KvȂȂB
	// ƂA operator [] 𓯎ɒ`uI[o[[h֐BṽG[oB
	operator       _Ty *(void)       { return m_pBuffer; }
	operator const _Ty *(void) const { return m_pBuffer; }

private:
	const size_t m_nSize;
	_Ty   *const m_pBuffer;

	void _assign(const _Ty *data, const size_t size)
	{
		_Ty *pBuffer = m_pBuffer;
		for(size_t i = 0; i < size; i++)
		{
			*pBuffer++ = *data++;
		}
	}

	void _assign(const _Ty &datum, const size_t size)
	{
		_Ty *pBuffer = m_pBuffer;
		for(size_t i = 0; i < size; i++)
		{
			*pBuffer++ = datum;
		}
	}
};

_SGC_END


#endif // __SGC_ARRAY__
