// COM_OleDropTarget.cpp cCve[Vt@C
#include "COM_OleDropTarget.h"
#include <assert.h>


_WXC_BEGIN                              // namespace wxc {


////////////////////////////////////////////////////////////
// RXgNV

COM_OleDropTarget::COM_OleDropTarget(void)
{
	m_pDropTarget = new _CDropTarget;
	m_pDropTarget->AddRef();
}

COM_OleDropTarget::~COM_OleDropTarget(void)
{
	m_pDropTarget->Release();
}

void COM_OleDropTarget::Register(wgc::Window *pWnd)
{
	assert(pWnd != NULL);
	m_pDropTarget->SetWindow(pWnd);
	pWnd->RegisterDragDrop(m_pDropTarget);
}


////////////////////////////////////////////////////////////
// COM_OleDropTarget::_CDropTarget ̃Cve[V
COM_OleDropTarget::_CDropTarget::_CDropTarget(void)
	: m_pWnd(NULL), m_lRefCount(0)
{
}

COM_OleDropTarget::_CDropTarget::~_CDropTarget(void)
{
}

void COM_OleDropTarget::_CDropTarget::SetWindow(wgc::Window *pWnd)
{
	assert(pWnd != NULL);
	m_pWnd = pWnd;
}


// IUnknown \bh
HRESULT STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::QueryInterface(REFIID iid, void **ppv)
{
	if(IsEqualIID(iid, IID_IUnknown) || IsEqualIID(iid, IID_IDropTarget))
	{
		*ppv = this;
		AddRef();
		return S_OK;
	}

	*ppv = NULL;
	return E_NOINTERFACE;
}

ULONG STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::AddRef(void)
{
	// QƃJEgCNg
	::InterlockedIncrement(&m_lRefCount);
	return m_lRefCount;
}

ULONG STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::Release(void)
{
	assert(m_lRefCount > 0);

	// QƃJEgfNg
	if(::InterlockedDecrement(&m_lRefCount) == 0)
	{
		// 0ɂȂ玩g폜
		delete this;
		return 0;
	}
	return m_lRefCount;
}


// IDropTarget \bh
HRESULT STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::DragEnter(
	IDataObject *pDataObject,
	DWORD grfKeyState,
	POINTL pt,
	DWORD *pdwEffect)
{
	*pdwEffect = m_pWnd->OnDragEnter(pDataObject, grfKeyState, pt);
	return S_OK;
}

HRESULT STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::DragOver(
	DWORD grfKeyState,
	POINTL pt,
	DWORD *pdwEffect)
{
	*pdwEffect = m_pWnd->OnDragOver(grfKeyState, pt);
	return S_OK;
}

HRESULT STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::DragLeave(void)
{
	m_pWnd->OnDragLeave();
	return S_OK;
}

HRESULT STDMETHODCALLTYPE COM_OleDropTarget::_CDropTarget::Drop(
	IDataObject *pDataObject,
	DWORD grfKeyState,
	POINTL pt,
	DWORD *pdwEffect)
{
	*pdwEffect = m_pWnd->OnDrop(pDataObject, grfKeyState, pt);
	return S_OK;
}

_WXC_END                                // }
