// ScrollBarCtrl.cpp cCve[Vt@C
#include "ScrollBarCtrl.h"


_WGC_BEGIN                              // namespace wgc {

// RXgN^
ScrollBarCtrl::ScrollBarCtrl(HWND hWnd /* = NULL */) : Control(hWnd)
{
}

// fXgN^
ScrollBarCtrl::~ScrollBarCtrl(void)
{
}


// XN[
BOOL ScrollBarCtrl::SetScrollInfo(const SCROLLINFO &si, const BOOL bRedraw /* = TRUE */)
{
	const LRESULT lResult = SendMessage(SBM_SETSCROLLINFO, bRedraw, (LPARAM)&si);
	return static_cast<BOOL>(lResult);
//	return ::SetScrollInfo(m_hWnd, SB_CTL, &si, bRedraw);
}

BOOL ScrollBarCtrl::GetScrollInfo(SCROLLINFO &si, const UINT nMask /* = SIF_ALL */) const
{
	si.cbSize = sizeof(si);
	si.fMask  = nMask;
	const LRESULT lResult = SendMessage(SBM_GETSCROLLINFO, 0, (LPARAM)&si);
	return static_cast<BOOL>(lResult);
//	return ::GetScrollInfo(m_hWnd, SB_CTL, &si);
}


// y[WTCY
int ScrollBarCtrl::GetPageSize(void) const
{
	SCROLLINFO si;
	GetScrollInfo(si, SIF_PAGE);
	return si.nPage;
}

int ScrollBarCtrl::SetPageSize(const int nSize)
{
	SCROLLINFO si;
	si.cbSize = sizeof(si);
	si.fMask  = SIF_PAGE;
	si.nPage  = nSize;

	SetScrollInfo(si);
	return si.nPage;
}


// ͈
void ScrollBarCtrl::GetRange(int &rMin, int &rMax) const
{
	SendMessage(SBM_GETRANGE, (WPARAM)&rMin, (LPARAM)&rMax);
}

void ScrollBarCtrl::SetRange(const int nMin, const int nMax, const BOOL bRedraw /* = FALSE */)
{
	if(bRedraw)
	{
		SendMessage(SBM_SETRANGEREDRAW, nMin, nMax);
	}
	else
	{
		SendMessage(SBM_SETRANGE, nMin, nMax);
	}
}


// XN[ʒu
int ScrollBarCtrl::GetPos(void) const
{
	const LRESULT lResult = SendMessage(SBM_GETPOS);
	return static_cast<int>(lResult);
}

void ScrollBarCtrl::SetPos(const int nPos, const BOOL bRedraw /* = TRUE */)
{
	SendMessage(SBM_SETPOS, nPos, bRedraw);
}


// 
BOOL ScrollBarCtrl::EnableArrow(const UINT /* nArrowFlags = ESB_ENABLE_BOTH */)
{
	return TRUE;
}


int ScrollBarCtrl::GetLimit(void) const
{
	return 1;
}

_WGC_END                                // }
