// ReBarCtrl.cpp cCve[Vt@C
// dynamic_castZqgĂ̂ŁA^C^Lɂ邱
#include "ReBarCtrl.h"
#include "ToolBarCtrl.h"
#include <assert.h>


_WGC_BEGIN                              // namespace wgc {

// RXgN^
ReBarCtrl::ReBarCtrl(void)
{
	INITCOMMONCONTROLSEX ic = {sizeof(ic)};
	ic.dwICC = ICC_COOL_CLASSES;
	::InitCommonControlsEx(&ic);
}

// fXgN^
ReBarCtrl::~ReBarCtrl(void)
{
}

BOOL ReBarCtrl::Create(
	Window *pParent,
	const DWORD dwStyle      /* = WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_BORDER */,
	const DWORD dwCtlStyle   /* = CCS_NODIVIDER */,
	const DWORD dwReBarStyle /* = RBS_BANDBORDERS */,
	const DWORD dwExStyle    /* = WS_EX_TOOLWINDOW */,
	const UINT nID           /* = ID_STD_REBAR */)
{
	assert(pParent != NULL);

	Control::Create(
		REBARCLASSNAME, NULL,
		dwStyle,
		dwCtlStyle | dwReBarStyle,
		dwExStyle,
		pParent, nID);

	REBARINFO rbi = {sizeof(rbi)};
    return SetBarInfo(rbi);
}


UINT ReBarCtrl::GetBandCount(void) const
{
	const LRESULT lResult = SendMessage(RB_GETBANDCOUNT);
	return static_cast<UINT>(lResult);
}

BOOL ReBarCtrl::GetBarInfo(REBARINFO &rbi) const
{
	const LRESULT lResult = SendMessage(RB_GETBARINFO, 0, reinterpret_cast<LPARAM>(&rbi));
	return static_cast<BOOL>(lResult);
}

BOOL ReBarCtrl::GetBandInfo(const UINT uBand, REBARBANDINFO &rbbi) const
{
	const LRESULT lResult = SendMessage(RB_GETBANDINFO, uBand, reinterpret_cast<LPARAM>(&rbbi));
	return static_cast<BOOL>(lResult);
}


BOOL ReBarCtrl::AddBar(
	Window *pWindow,
	const DWORD dwStyle /* = RBBS_GRIPPERALWAYS | RBBS_CHILDEDGE */,
	LPCTSTR lpszText    /* = NULL */,
	HBITMAP hBitmap     /* = NULL */)
{
	assert(pWindow != NULL);

	SIZE size;
	ToolBarCtrl *pToolBar = dynamic_cast<ToolBarCtrl *>(pWindow);
	if(pToolBar != NULL)
	{
		pToolBar->GetMaxSize(size);
	}
	else
	{
		RECT rect;
		pWindow->GetWindowRect(rect);
		size.cx = rect.right - rect.left;
		size.cy = rect.bottom - rect.top;
	}

	REBARBANDINFO rbbi = {sizeof(rbbi)};
	rbbi.fMask      = RBBIM_STYLE | RBBIM_CHILD | RBBIM_CHILDSIZE;
	rbbi.fStyle     = dwStyle;
	rbbi.hwndChild  = *pWindow;
	rbbi.cxMinChild = size.cx;
	rbbi.cyMinChild = size.cy;

	if(lpszText != NULL)
	{
		rbbi.fMask |= RBBIM_TEXT;
		rbbi.lpText = const_cast<LPTSTR>(lpszText);
	}
	if(hBitmap != NULL)
	{
		rbbi.fMask |= RBBIM_BACKGROUND;
		rbbi.hbmBack = hBitmap;
	}
	return InsertBand(static_cast<UINT>(-1), rbbi);
}

BOOL ReBarCtrl::SetBarInfo(const REBARINFO &rbi)
{
	REBARINFO tmp = rbi;
	const LRESULT lResult = SendMessage(RB_SETBARINFO, 0, reinterpret_cast<LPARAM>(&tmp));
	return static_cast<BOOL>(lResult);
}

BOOL ReBarCtrl::SetBandInfo(const UINT uBand, const REBARBANDINFO &rbbi)
{
	REBARBANDINFO tmp = rbbi;
	const LRESULT lResult = SendMessage(RB_SETBANDINFO, uBand, reinterpret_cast<LPARAM>(&tmp));
	return static_cast<BOOL>(lResult);
}

BOOL ReBarCtrl::InsertBand(const UINT uBand, const REBARBANDINFO &rbbi)
{
	REBARBANDINFO tmp = rbbi;
	const LRESULT lResult = SendMessage(RB_INSERTBAND, uBand, reinterpret_cast<LPARAM>(&tmp));
	return static_cast<BOOL>(lResult);
}

BOOL ReBarCtrl::DeleteBand(const UINT uBand)
{
	const LRESULT lResult = SendMessage(RB_DELETEBAND, uBand);
	return static_cast<BOOL>(lResult);
}

_WGC_END                                // }
