// ListBoxCtrl.h cXg{bNXRg[̃TuNX
#ifndef __WGC_LISTBOXCTRL__
#define __WGC_LISTBOXCTRL__

#include "Control.h"
#include <commctrl.h>


_WGC_BEGIN                              // namespace wgc {

class ListBoxCtrl : public Control
{
public:
	////////////////////////////////////////////////////////////////
	// RXgN^^fXgN^
	explicit ListBoxCtrl(HWND hWnd = NULL);
	virtual ~ListBoxCtrl(void);

	UINT InitStorage(const UINT uItems, const UINT uBytes);

	// ֘Atf[^
	void      SetItemData(const UINT uIndex, const DWORD_PTR dwItemData);
	DWORD_PTR GetItemData(const UINT uIndex) const;

	// eLXg擾
	SIZE_T GetText(const UINT uIndex, LPTSTR lpszBuffer) const;
	void   GetText(const UINT uIndex, tstring_t &rString) const;
	SIZE_T GetTextLen(const UINT uIndex) const;

	// eLXgݒ
	UINT AddString(LPCTSTR lpszItem);
	UINT AddString(const tstring_t &rString);
	UINT InsertString(const int nIndex, LPCTSTR lpszItem);
	UINT InsertString(const int nIndex, const tstring_t &rString);

	// ACe
	UINT GetCount(void) const;

	// PI
	int  GetCurSel(void) const;
	void SetCurSel(const int nIndex = -1);

	// I
	BOOL GetSel(const UINT uIndex) const;
	void SetSel(const int  nIndex = -1, const BOOL bSelect = TRUE);
	UINT GetSelCount(void) const;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(ListBoxCtrl)
};

_WGC_END                                // }

#endif // __WGC_LISTBOXCTRL__
