// DialogPropertySheet.cpp cCve[Vt@C
#include "DialogPropertySheet.h"
#include "TabCtrl.h"
#include "wgfunc.h"


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////////////////////////
// \z

// RXgN^
DialogPropertySheet::DialogPropertySheet(const UINT uCaptionID, HINSTANCE hResource, HWND hWndParent /* = NULL */, const UINT nStartPage /* = 0 */, const DWORD dwPshFlags /* = PSH_DEFAULT */)
	: Dialog(hResource, NULL, hWndParent), m_uCaptionID(uCaptionID), m_dwPshFlags(dwPshFlags), m_nStartPage(nStartPage)
{
	wgc::wgfLoadString(m_hResource, m_uCaptionID, m_caption);
}

// fXgN^
DialogPropertySheet::~DialogPropertySheet(void)
{
}


INT_PTR DialogPropertySheet::DoModal(const LPARAM /* dwInitParam = 0 */)
{
	PROPSHEETHEADER psh;
	SetPSH(psh);

	_SetHookTarget(this);
	const INT_PTR result = ::PropertySheet(&psh);
	if(result < 0)
	{
		_SetHookTarget(NULL);
		wgfThrowLastError();
	}
	return result;
}

// [hX\
BOOL DialogPropertySheet::DoModeless(const LPARAM /* dwInitParam = 0 */)
{
	// 
	return TRUE;
}


void DialogPropertySheet::SetSheets(LPPROPPAGE_OBJ pPageArray[], const int nSheetCount)
{
	m_vPropSheetPage.resize(nSheetCount);
	for(int i = 0; i < nSheetCount; i++)
	{
		pPageArray[i]->GetPropPage(m_vPropSheetPage[i]);
	}
}

void DialogPropertySheet::SetPSH(PROPSHEETHEADER &psh) const
{
	psh.dwSize     = sizeof(psh);
	psh.dwFlags    = PSH_PROPSHEETPAGE | (m_dwPshFlags & (PSH_HASHELP | PSH_NOAPPLYNOW | PSH_NOCONTEXTHELP));
	psh.hwndParent = m_hWndParent;
	psh.nStartPage = m_nStartPage;
	psh.nPages     = static_cast<int>(m_vPropSheetPage.size());
	psh.ppsp       =                 &m_vPropSheetPage[0];
	psh.hInstance  = m_hResource;
	psh.pszCaption = m_caption.c_str();
}


HWND DialogPropertySheet::GetTabControl(void) const
{
	return PropSheet_GetTabControl(m_hWnd);
}

int DialogPropertySheet::GetCurSel(void) const
{
	TabCtrl ctrl(GetTabControl());
	return ctrl.GetCurSel();
}


////////////////////////////////////////////////////////////////////////////////
// TuNX
void DialogPropertySheet::Subclass(HWND hWnd)
{
	Window::Subclass(hWnd);
}

void DialogPropertySheet::Unsubclass(void)
{
	Window::Unsubclass();
}


////////////////////////////////////////////////////////////////////////////////
// bZ[Wnh

LRESULT DialogPropertySheet::_Default(void)
{
	return Window::_Default();
}

BOOL DialogPropertySheet::OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl)
{
	switch(wID)
	{
	case IDAPPLY:
		OnApply();
		return FALSE;

	case IDHELP:
		OnHelp();
		return FALSE;
	}
	return Dialog::OnCommand(wNotifyCode, wID, hWndCtrl);
}


////////////////////////////////////////////////////////////////////////////////
// W{^̏
// EndDialog() ĂяoĂ̓_

// OK{^
void DialogPropertySheet::OnOK(void)
{
	_Default();
}

// LZ{^
void DialogPropertySheet::OnCancel(void)
{
	_Default();
}

// Kp{^
void DialogPropertySheet::OnApply(void)
{
	_Default();
}

// wv{^
void DialogPropertySheet::OnHelp(void)
{
	_Default();
}

_WGC_END                                // }
