// COM_IDataObject.cpp cCve[Vt@C
#include "COM_IDataObject.h"
#include <assert.h>                     // assert()


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////
// RXgNV

COM_IDataObject::COM_IDataObject(void)
	: m_lRefCount(0)
{
}

COM_IDataObject::~COM_IDataObject(void)
{
	for(object_list_t::iterator p = m_object_list.begin(); p != m_object_list.end(); p++)
	{
		// Xg[WfBÅJ`ΊJ
		if(p->release)
		{
			::ReleaseStgMedium(&p->medium);
		}
	}
}

// CX^X쐬
IDataObject *COM_IDataObject::CreateInstance(void)
{
	IDataObject *pDataObject = new COM_IDataObject();
	pDataObject->AddRef();

	return pDataObject;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::QueryInterface(
	REFIID iid,
	void **ppv)
{
	if(IsEqualIID(iid, IID_IUnknown) || IsEqualIID(iid, IID_IDataObject))
	{
		*ppv = this;
		AddRef();
		return S_OK;
	}

	*ppv = NULL;
	return E_NOINTERFACE;
}

ULONG STDMETHODCALLTYPE COM_IDataObject::AddRef()
{
	// QƃJEgCNg
	::InterlockedIncrement(&m_lRefCount);
	return m_lRefCount;
}

ULONG STDMETHODCALLTYPE COM_IDataObject::Release()
{
	assert(m_lRefCount > 0);

	// QƃJEgfNg
	if(::InterlockedDecrement(&m_lRefCount) == 0)
	{
		// 0ɂȂ玩g폜
		delete this;
		return 0;
	}
	return m_lRefCount;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::GetData(
	FORMATETC *pFormatEtc,
	STGMEDIUM *pMedium)
{
	// `FbN
	if(pFormatEtc == NULL || pMedium == NULL)
	{
		return E_INVALIDARG;
	}

	if((pFormatEtc->dwAspect & DVASPECT_CONTENT) == 0)
	{
		return DV_E_DVASPECT;
	}

	if(pFormatEtc->lindex != -1)
	{
		return DV_E_LINDEX;
	}

	// IuWFNg̃Xgɍvf[^
	for(object_list_t::iterator p = m_object_list.begin(); p != m_object_list.end(); p++)
	{
		// vꂽf[^^CvRs[쐬
		if(p->format.cfFormat == pFormatEtc->cfFormat
		&&(p->format.tymed & pFormatEtc->tymed) != 0)
		{
			return _DuplicateMedium(pMedium, &p->medium, pFormatEtc->cfFormat);
		}
	}

	return DV_E_FORMATETC;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::GetDataHere(
	FORMATETC * /* pFormatEtc */,
	STGMEDIUM * /* pMedium */)
{
	return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::QueryGetData(FORMATETC *pFormatEtc)
{
	// `FbN
	if(pFormatEtc == NULL)
	{
		return E_INVALIDARG;
	}

	if((pFormatEtc->dwAspect & DVASPECT_CONTENT) == 0)
	{
		return DV_E_DVASPECT;
	}

	if(pFormatEtc->lindex != -1)
	{
		return DV_E_LINDEX;
	}

	for(object_list_t::iterator p = m_object_list.begin(); p != m_object_list.end(); p++)
	{
		// vꂽf[^^CvOKԂ
		if(p->format.cfFormat == pFormatEtc->cfFormat
		&&(p->format.tymed & pFormatEtc->tymed) != 0)
		{
			return S_OK;
		}
	}

	return DV_E_FORMATETC;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::EnumFormatEtc(
	DWORD             /* dwDirection */,
	IEnumFORMATETC ** /* ppEnumFormatEtc */)
{
	return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::SetData(
	FORMATETC *pFormatEtc,
	STGMEDIUM *pMedium,
	BOOL fRelease)
{
	if(pFormatEtc == NULL || pMedium == NULL)
	{
		return E_INVALIDARG;
	}

	// VIuWFNg쐬
	object_t object;
	object.release = fRelease;
	object.format  = *pFormatEtc;
	object.medium  = *pMedium;

	// 쐬IuWFNg}
	m_object_list.push_back(object);
	return S_OK;
}


HRESULT STDMETHODCALLTYPE COM_IDataObject::GetCanonicalFormatEtc(
	FORMATETC * /* pFormatetcIn */,
	FORMATETC * /* pFormatetcOut */)
{
	return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::DAdvise(
	FORMATETC   * /* pFormatEtc */,
	DWORD         /* advf */,
	IAdviseSink * /* pAdvSink */,
	DWORD       * /* pdwConnection */)
{
	return OLE_E_ADVISENOTSUPPORTED;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::DUnadvise(
	DWORD /* dwConnection */)
{
	return OLE_E_ADVISENOTSUPPORTED;
}

HRESULT STDMETHODCALLTYPE COM_IDataObject::EnumDAdvise(
	IEnumSTATDATA ** /* ppenumAdvise */)
{
	return OLE_E_ADVISENOTSUPPORTED;
}


// Xg[WfBA̕쐬
HRESULT COM_IDataObject::_DuplicateMedium(
	STGMEDIUM *dst,
	const STGMEDIUM *src,
	const CLIPFORMAT cfFormat)
{
	*dst = *src;
	if(src->pUnkForRelease != NULL)
	{
		// [XpIuWFNg΁A炸ɎQƃJEg𑝂₷
		src->pUnkForRelease->AddRef();
		return S_OK;
	}

	// 쐬
	HANDLE hData = NULL;
	switch(src->tymed)
	{
	case TYMED_HGLOBAL:
		hData = ::OleDuplicateData(src->hGlobal, cfFormat, 0);
		dst->hGlobal = reinterpret_cast<HGLOBAL>(hData);
		break;
	}

	if(hData == NULL)
	{
		return DV_E_FORMATETC;
	}
	return S_OK;
}

_WGC_END                                // }
