// CommandInterface.h cR}hC^[tF[X
#ifndef __COMMAND_INTERFACE__
#define __COMMAND_INTERFACE__

#include <windows.h>


// NX
class command_interface
{
public:
	virtual void check (const UINT uCommand, const BOOL bCheck  = TRUE) const = 0;
	virtual void enable(const UINT uCommand, const BOOL bEnable = TRUE) const = 0;
	virtual void radio (const UINT uCommandFirst, const UINT uCommandLast, const UINT uCommandRadio) const = 0;
};


// j[pR}hC^[tF[X
class command_interface_menu : public command_interface
{
public:
	command_interface_menu(HMENU hMenu);

	void check (const UINT uCommand, const BOOL bCheck  = TRUE) const;
	void enable(const UINT uCommand, const BOOL bEnable = TRUE) const;
	void radio (const UINT uCommandFirst, const UINT uCommandLast, const UINT uCommandRadio) const;

private:
	HMENU m_hMenu;
};


// c[o[pR}hC^[tF[X
class command_interface_toolbar : public command_interface
{
public:
	command_interface_toolbar(HWND hWndToolBar);

	void check (const UINT uCommand, const BOOL bCheck  = TRUE) const;
	void enable(const UINT uCommand, const BOOL bEnable = TRUE) const;
	void radio (const UINT uCommandFirst, const UINT uCommandLast, const UINT uCommandRadio) const;

private:
	HWND m_hWndToolBar;
};

#endif // __COMMAND_INTERFACE__
