/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class DelegateFileFilter
extends AbstractFileFilter {
    private FilenameFilter filename;
    private FileFilter file;

    public DelegateFileFilter(FilenameFilter filter) {
        if (filter == null) {
            throw new NullPointerException("Setting a filter to null will infinitely loop. Use a NullFileFilter instead. ");
        }
        this.filename = filter;
    }

    public DelegateFileFilter(FileFilter filter) {
        if (filter == null) {
            throw new NullPointerException("Setting a filter to null will infinitely loop. Use a NullFileFilter instead. ");
        }
        this.file = filter;
    }

    public boolean accept(File f) {
        if (this.file != null) {
            return this.file.accept(f);
        }
        return super.accept(f);
    }

    public boolean accept(File dir, String name) {
        if (this.filename != null) {
            return this.filename.accept(dir, name);
        }
        return super.accept(dir, name);
    }
}

