/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.compress.tar;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.compress.tar.TarUtils;

public class TarEntry {
    public static final int NAMELEN = 100;
    private int m_checkSum;
    private int m_devMajor;
    private int m_devMinor;
    private File m_file;
    private int m_groupID;
    private StringBuffer m_groupName;
    private byte m_linkFlag;
    private StringBuffer m_linkName;
    private StringBuffer m_magic = new StringBuffer("ustar");
    private long m_modTime;
    private int m_mode;
    private StringBuffer m_name = new StringBuffer();
    private long m_size;
    private int m_userID;
    private StringBuffer m_userName;

    public TarEntry(String name) {
        this();
        boolean isDir = name.endsWith("/");
        this.m_name = new StringBuffer(name);
        this.m_mode = isDir ? 16877 : 33188;
        this.m_linkFlag = (byte)(isDir ? 53 : 48);
        this.m_modTime = new Date().getTime() / 1000L;
        this.m_linkName = new StringBuffer("");
        this.m_userName = new StringBuffer("");
        this.m_groupName = new StringBuffer("");
    }

    public TarEntry(String name, byte linkFlag) {
        this(name);
        this.m_linkFlag = linkFlag;
    }

    public TarEntry(File file) {
        this();
        int colon;
        this.m_file = file;
        String name = file.getPath();
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (-1 != osName.indexOf("netware")) {
            if (name.length() > 2) {
                char ch1 = name.charAt(0);
                char ch2 = name.charAt(1);
                if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                    name = name.substring(2);
                }
            }
        } else if (-1 != osName.indexOf("netware") && (colon = name.indexOf(58)) != -1) {
            name = name.substring(colon + 1);
        }
        name = name.replace(File.separatorChar, '/');
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        this.m_linkName = new StringBuffer("");
        this.m_name = new StringBuffer(name);
        if (file.isDirectory()) {
            this.m_mode = 16877;
            this.m_linkFlag = (byte)53;
            if (this.m_name.charAt(this.m_name.length() - 1) != '/') {
                this.m_name.append("/");
            }
        } else {
            this.m_mode = 33188;
            this.m_linkFlag = (byte)48;
        }
        this.m_size = file.length();
        this.m_modTime = file.lastModified() / 1000L;
        this.m_checkSum = 0;
        this.m_devMajor = 0;
        this.m_devMinor = 0;
    }

    public TarEntry(byte[] header) {
        this();
        this.parseTarHeader(header);
    }

    private TarEntry() {
        this.m_linkName = new StringBuffer();
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.m_userName = new StringBuffer(user);
        this.m_groupName = new StringBuffer("");
    }

    public void setGroupID(int groupId) {
        this.m_groupID = groupId;
    }

    public void setGroupId(int groupId) {
        this.m_groupID = groupId;
    }

    public void setGroupName(String groupName) {
        this.m_groupName = new StringBuffer(groupName);
    }

    public void setModTime(long time) {
        this.m_modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.m_modTime = time.getTime() / 1000L;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public void setName(String name) {
        this.m_name = new StringBuffer(name);
    }

    public void setSize(long size) {
        this.m_size = size;
    }

    public void setUserID(int userId) {
        this.m_userID = userId;
    }

    public void setUserId(int userId) {
        this.m_userID = userId;
    }

    public void setUserName(String userName) {
        this.m_userName = new StringBuffer(userName);
    }

    public TarEntry[] getDirectoryEntries() {
        if (null == this.m_file || !this.m_file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] list = this.m_file.list();
        TarEntry[] result = new TarEntry[list.length];
        int i = 0;
        while (i < list.length) {
            result[i] = new TarEntry(new File(this.m_file, list[i]));
            ++i;
        }
        return result;
    }

    public File getFile() {
        return this.m_file;
    }

    public int getGroupId() {
        return this.m_groupID;
    }

    public int getGroupID() {
        return this.m_groupID;
    }

    public String getGroupName() {
        return this.m_groupName.toString();
    }

    public Date getModTime() {
        return new Date(this.m_modTime * 1000L);
    }

    public int getMode() {
        return this.m_mode;
    }

    public String getName() {
        return this.m_name.toString();
    }

    public long getSize() {
        return this.m_size;
    }

    public int getCheckSum() {
        return this.m_checkSum;
    }

    public int getUserId() {
        return this.m_userID;
    }

    public int getUserID() {
        return this.m_userID;
    }

    public String getUserName() {
        return this.m_userName.toString();
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.getName().startsWith(this.getName());
    }

    public boolean isDirectory() {
        if (this.m_file != null) {
            return this.m_file.isDirectory();
        }
        if (this.m_linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public boolean isGNULongNameEntry() {
        return this.m_linkFlag == 76 && this.m_name.toString().equals("././@LongLink");
    }

    public boolean equals(TarEntry other) {
        return this.getName().equals(other.getName());
    }

    private void parseTarHeader(byte[] header) {
        int offset = 0;
        this.m_name = TarUtils.parseName(header, offset, 100);
        this.m_mode = (int)TarUtils.parseOctal(header, offset += 100, 8);
        this.m_userID = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.m_groupID = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.m_size = TarUtils.parseOctal(header, offset += 8, 12);
        this.m_modTime = TarUtils.parseOctal(header, offset += 12, 12);
        this.m_checkSum = (int)TarUtils.parseOctal(header, offset += 12, 8);
        offset += 8;
        this.m_linkFlag = header[offset++];
        this.m_linkName = TarUtils.parseName(header, offset, 100);
        this.m_magic = TarUtils.parseName(header, offset += 100, 8);
        this.m_userName = TarUtils.parseName(header, offset += 8, 32);
        this.m_groupName = TarUtils.parseName(header, offset += 32, 32);
        this.m_devMajor = (int)TarUtils.parseOctal(header, offset += 32, 8);
        this.m_devMinor = (int)TarUtils.parseOctal(header, offset += 8, 8);
    }

    public void writeEntryHeader(byte[] buffer) {
        int offset = 0;
        offset = TarUtils.getNameBytes(this.m_name, buffer, offset, 100);
        offset = TarUtils.getOctalBytes(this.m_mode, buffer, offset, 8);
        offset = TarUtils.getOctalBytes(this.m_userID, buffer, offset, 8);
        offset = TarUtils.getOctalBytes(this.m_groupID, buffer, offset, 8);
        offset = TarUtils.getLongOctalBytes(this.m_size, buffer, offset, 12);
        int checkSumOffset = offset = TarUtils.getLongOctalBytes(this.m_modTime, buffer, offset, 12);
        int i = 0;
        while (i < 8) {
            buffer[offset++] = 32;
            ++i;
        }
        buffer[offset++] = this.m_linkFlag;
        offset = TarUtils.getNameBytes(this.m_linkName, buffer, offset, 100);
        offset = TarUtils.getNameBytes(this.m_magic, buffer, offset, 8);
        offset = TarUtils.getNameBytes(this.m_userName, buffer, offset, 32);
        offset = TarUtils.getNameBytes(this.m_groupName, buffer, offset, 32);
        offset = TarUtils.getOctalBytes(this.m_devMajor, buffer, offset, 8);
        offset = TarUtils.getOctalBytes(this.m_devMinor, buffer, offset, 8);
        while (offset < buffer.length) {
            buffer[offset++] = 0;
        }
        long checkSum = TarUtils.computeCheckSum(buffer);
        TarUtils.getCheckSumOctalBytes(checkSum, buffer, checkSumOffset, 8);
    }
}

