/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.vdoclet;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.tags.velocity.JellyContextAdapter;
import org.apache.velocity.context.Context;
import vdoclet.Generator;
import vdoclet.docinfo.DocInfo;
import vdoclet.docinfo.QDoxBuilder;

public class VDocletBean {
    File srcDir;
    File destDir;
    String outputFile;
    String template;
    String encoding;
    boolean verbose = false;
    DocInfo docInfo;
    JellyContext jellyContext;

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setJellyContext(JellyContext jellyContext) {
        this.jellyContext = jellyContext;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void execute() throws Exception {
        this.parseSources();
        this.generate();
    }

    void log(String msg) {
        if (this.verbose) {
            System.err.println(msg);
        }
    }

    void parseSources() throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSourceTree(this.srcDir);
        JavaSource[] javaSources = builder.getSources();
        this.log(javaSources.length + " source-files");
        this.docInfo = QDoxBuilder.build((JavaSource[])javaSources);
        this.docInfo.setSourcePath(this.srcDir.getAbsolutePath());
    }

    void generate() throws Exception {
        if (!this.destDir.exists()) {
            this.destDir.mkdirs();
        }
        Generator generator = new Generator(this.destDir);
        generator.setAttribute("docInfo", (Object)this.docInfo);
        if (this.jellyContext != null) {
            generator.setAttribute("jellyContext", (Object)this.getJellyContextAdapter());
        }
        if (this.encoding != null) {
            generator.setAttribute("encoding", (Object)this.encoding);
        }
        generator.eval(this.template, (Writer)new FileWriter(new File(this.destDir, this.outputFile)));
    }

    private Context getJellyContextAdapter() {
        JellyContextAdapter adapter = new JellyContextAdapter(this.jellyContext);
        adapter.setReadOnly(true);
        return adapter;
    }
}

