/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ExceptionUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    protected static String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested"};
    static /* synthetic */ Class class$java$lang$Throwable;

    protected ExceptionUtils() {
    }

    public static void addCauseMethodName(String methodName) {
        if (methodName != null && methodName.length() > 0) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(CAUSE_METHOD_NAMES));
            list.add(methodName);
            CAUSE_METHOD_NAMES = list.toArray(new String[list.size()]);
        }
    }

    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            int i = 0;
            while (i < methodNames.length) {
                cause = ExceptionUtils.getCauseUsingMethodName(throwable, methodNames[i]);
                if (cause != null) break;
                ++i;
            }
            if (cause == null) {
                cause = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = ExceptionUtils.getCause(throwable);
        if (cause != null) {
            throwable = cause;
            while ((throwable = ExceptionUtils.getCause(throwable)) != null) {
                cause = throwable;
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (method != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException ignored) {
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (field != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
        }
        return null;
    }

    public static int getThrowableCount(Throwable throwable) {
        int count = 0;
        while (throwable != null) {
            ++count;
            throwable = ExceptionUtils.getCause(throwable);
        }
        return count;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            list.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static int indexOfThrowable(Throwable throwable, Class type) {
        return ExceptionUtils.indexOfThrowable(throwable, type, 0);
    }

    public static int indexOfThrowable(Throwable throwable, Class type, int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + fromIndex);
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(throwable);
        if (fromIndex >= throwables.length) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + fromIndex);
        }
        int i = fromIndex;
        while (i < throwables.length) {
            if (throwables[i].getClass().equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable t, PrintStream stream) {
        String[] trace = ExceptionUtils.getRootCauseStackTrace(t);
        int i = 0;
        while (i < trace.length) {
            stream.println(trace[i]);
            ++i;
        }
        stream.flush();
    }

    public static void printRootCauseStackTrace(Throwable t) {
        ExceptionUtils.printRootCauseStackTrace(t, System.err);
    }

    public static void printRootCauseStackTrace(Throwable t, PrintWriter writer) {
        String[] trace = ExceptionUtils.getRootCauseStackTrace(t);
        int i = 0;
        while (i < trace.length) {
            writer.println(trace[i]);
            ++i;
        }
        writer.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable t) {
        Throwable[] throwables = ExceptionUtils.getThrowables(t);
        int count = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List nextTrace = ExceptionUtils.getStackFrameList(throwables[count - 1]);
        int i = count;
        while (--i >= 0) {
            List trace = nextTrace;
            if (i != 0) {
                nextTrace = ExceptionUtils.getStackFrameList(throwables[i - 1]);
                ExceptionUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == count - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            int j = 0;
            while (j < trace.size()) {
                frames.add((String)trace.get(j));
                ++j;
            }
        }
        return frames.toArray(new String[0]);
    }

    private static void removeCommonFrames(List causeFrames, List wrapperFrames) {
        int causeFrameIndex = causeFrames.size() - 1;
        int wrapperFrameIndex = wrapperFrames.size() - 1;
        while (causeFrameIndex >= 0 && wrapperFrameIndex >= 0) {
            String wrapperFrame;
            String causeFrame = (String)causeFrames.get(causeFrameIndex);
            if (causeFrame.equals(wrapperFrame = (String)wrapperFrames.get(wrapperFrameIndex))) {
                causeFrames.remove(causeFrameIndex);
            }
            --causeFrameIndex;
            --wrapperFrameIndex;
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getFullStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = ExceptionUtils.getThrowables(t);
        int i = 0;
        while (i < ts.length) {
            ts[i].printStackTrace(pw);
            if (ExceptionUtils.isNestedThrowable(ts[i])) break;
            ++i;
        }
        return sw.getBuffer().toString();
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        int sz = CAUSE_METHOD_NAMES.length;
        int i = 0;
        while (i < sz) {
            try {
                Method method = throwable.getClass().getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
            ++i;
        }
        try {
            Field field = throwable.getClass().getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {}
        return false;
    }

    public static String[] getStackFrames(Throwable t) {
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(t));
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = System.getProperty("line.separator");
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return list.toArray(new String[0]);
    }

    static List getStackFrameList(Throwable t) {
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = System.getProperty("line.separator");
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token = frames.nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().length() == 0) {
                traceStarted = true;
                list.add(token);
                continue;
            }
            if (traceStarted) break;
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

