/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.plexus.util.SelectorUtils;

public class DirectoryScanner {
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            int i = 0;
            while (i < includes.length) {
                String pattern = includes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.includes[i] = pattern;
                ++i;
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                String pattern = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.excludes[i] = pattern;
                ++i;
            }
        }
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.scandir(this.basedir, "", true);
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] excl = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(excl);
        Object[] notIncl = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(notIncl);
        int i = 0;
        while (i < excl.length) {
            if (!this.couldHoldIncluded((String)excl[i])) {
                this.scandir(new File(this.basedir, (String)excl[i]), (String)excl[i] + File.separator, false);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < notIncl.length) {
            if (!this.couldHoldIncluded((String)notIncl[i2])) {
                this.scandir(new File(this.basedir, (String)notIncl[i2]), (String)notIncl[i2] + File.separator, false);
            }
            ++i2;
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            // empty if block
        }
        if (!this.followSymlinks) {
            Vector<Object> noLinks = new Vector<Object>();
            int i = 0;
            while (i < newfiles.length) {
                try {
                    if (this.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + (String)newfiles[i];
                        File file = new File(dir, (String)newfiles[i]);
                        if (file.isDirectory()) {
                            this.dirsExcluded.addElement(name);
                        } else {
                            this.filesExcluded.addElement(name);
                        }
                    } else {
                        noLinks.addElement(newfiles[i]);
                    }
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get cannonical path!";
                    System.err.println(msg);
                    noLinks.addElement(newfiles[i]);
                }
                ++i;
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        int i = 0;
        while (i < newfiles.length) {
            String name = vpath + newfiles[i];
            File file = new File(dir, (String)newfiles[i]);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        if (this.isSelected(name, file)) {
                            this.dirsIncluded.addElement(name);
                            if (fast) {
                                this.scandir(file, name + File.separator, fast);
                            }
                        } else {
                            this.everythingIncluded = false;
                            this.dirsDeselected.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(file, name + File.separator, fast);
                            }
                        }
                    } else {
                        this.everythingIncluded = false;
                        this.dirsExcluded.addElement(name);
                        if (fast && this.couldHoldIncluded(name)) {
                            this.scandir(file, name + File.separator, fast);
                        }
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandir(file, name + File.separator, fast);
                    }
                }
                if (!fast) {
                    this.scandir(file, name + File.separator, fast);
                }
            } else if (file.isFile()) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        if (this.isSelected(name, file)) {
                            this.filesIncluded.addElement(name);
                        } else {
                            this.everythingIncluded = false;
                            this.filesDeselected.addElement(name);
                        }
                    } else {
                        this.everythingIncluded = false;
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.everythingIncluded = false;
                    this.filesNotIncluded.addElement(name);
                }
            }
            ++i;
        }
    }

    protected boolean isIncluded(String name) {
        int i = 0;
        while (i < this.includes.length) {
            if (DirectoryScanner.matchPath(this.includes[i], name, this.isCaseSensitive)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        int i = 0;
        while (i < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[i], name, this.isCaseSensitive)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        int i = 0;
        while (i < this.excludes.length) {
            if (DirectoryScanner.matchPath(this.excludes[i], name, this.isCaseSensitive)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        return true;
    }

    public String[] getIncludedFiles() {
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        return files;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    public String[] getIncludedDirectories() {
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        return directories;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++i;
        }
        this.excludes = newExcludes;
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File resolvedParent = new File(parent.getCanonicalPath());
        File toTest = new File(resolvedParent, name);
        return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
    }
}

