/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.plexus.DefaultPlexusContainer;
import org.apache.plexus.lifecycle.avalon.AvalonServiceManager;

public class PlexusLoaderServlet
extends HttpServlet {
    private DefaultPlexusContainer container;

    public void init() throws ServletException {
        super.init();
        this.log("Initializing Plexus...");
        String configFileName = this.getInitParameter("plexus-config");
        String applicationRoot = this.getServletContext().getRealPath("");
        System.getProperties().setProperty("plexus.home", applicationRoot + "/WEB-INF");
        File configuration = new File(applicationRoot, configFileName);
        FileReader config = null;
        try {
            config = new FileReader(configuration.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new ServletException("Could not find the Plexus configuration!", (Throwable)e);
        }
        this.container = new DefaultPlexusContainer();
        try {
            this.container.setConfigurationResource(config);
            this.container.initialize();
            this.container.start();
        }
        catch (Exception e) {
            throw new ServletException("Could not start Plexus!", (Throwable)e);
        }
        this.getServletContext().setAttribute("plexus.service.manager", (Object)new AvalonServiceManager(this.container.getComponentRepository()));
        this.log("Plexus Initializied.");
    }

    public void destroy() {
        try {
            this.container.dispose();
        }
        catch (Exception e) {
            this.log("Could not shutdown Plexus!", e);
        }
        super.destroy();
    }
}

