/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.j2ee;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import org.apache.maven.j2ee.WarFile;

public class WarClassLoader
extends URLClassLoader {
    private List tempFiles = new ArrayList();
    private WarFile war;

    public WarClassLoader(WarFile war) throws IOException, MalformedURLException {
        super(new URL[0]);
        this.war = war;
        this.addURLs();
    }

    public WarClassLoader(WarFile war, ClassLoader classloader) throws IOException, MalformedURLException {
        super(new URL[0], classloader);
        this.war = war;
        this.addURLs();
    }

    private void addURLs() throws IOException, MalformedURLException {
        File warFile = new File(this.war.getName());
        URL webInfClasses = new URL("jar:" + warFile.toURL() + "!/" + "WEB-INF/classes/");
        this.addURL(webInfClasses);
        Set jars = this.war.getLibEntries();
        JarEntry entry = null;
        Iterator jarEntries = jars.iterator();
        while (jarEntries.hasNext()) {
            entry = (JarEntry)jarEntries.next();
            File jar = this.war.extract(entry);
            this.tempFiles.add(jar);
            jar.deleteOnExit();
            this.addURL(new URL("jar:" + jar.toURL() + "!/"));
        }
    }
}

