/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.decorator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.WeightedPath;
import org.apache.commons.graph.algorithm.path.AllPairsShortestPath;
import org.apache.commons.graph.algorithm.spanning.MinimumSpanningForest;
import org.apache.commons.graph.domain.basic.DirectedGraphImpl;
import org.apache.commons.graph.domain.basic.DirectedGraphWrapper;
import org.apache.commons.graph.exception.GraphException;

public class DDirectedGraph
extends DirectedGraphWrapper
implements DirectedGraph,
WeightedGraph {
    private WeightedGraph weighted;
    private Map weights = new HashMap();
    private static Map decoratedGraphs = new HashMap();
    private AllPairsShortestPath allPaths = null;

    protected DDirectedGraph() {
    }

    protected DDirectedGraph(DirectedGraph impl) {
        super(impl);
        if (impl instanceof WeightedGraph) {
            this.weighted = (WeightedGraph)((Object)impl);
        }
    }

    public static DDirectedGraph decorateGraph(DirectedGraph graph) {
        if (graph instanceof DDirectedGraph) {
            return (DDirectedGraph)graph;
        }
        if (decoratedGraphs.containsKey(graph)) {
            return (DDirectedGraph)decoratedGraphs.get(graph);
        }
        DDirectedGraph RC = new DDirectedGraph(graph);
        decoratedGraphs.put(graph, RC);
        return RC;
    }

    public double getWeight(Edge e) {
        if (this.weighted != null) {
            return this.weighted.getWeight(e);
        }
        if (this.weights.containsKey(e)) {
            return (Double)this.weights.get(e);
        }
        return 1.0;
    }

    public void setWeight(Edge e, double value) throws GraphException {
        if (this.weighted != null) {
            throw new GraphException("Unable to set weight.");
        }
        this.weights.put(e, new Double(value));
    }

    /*
     * WARNING - void declaration
     */
    public DirectedGraph transpose() throws GraphException {
        try {
            void e;
            DirectedGraphImpl RC = new DirectedGraphImpl();
            Set vertexSet = this.getVertices();
            Set edgeSet = this.getEdges();
            Iterator vertices = vertexSet.iterator();
            while (vertices.hasNext()) {
                RC.addVertex((Vertex)vertices.next());
            }
            Iterator edges = edgeSet.iterator();
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                RC.addEdge(edge, this.getTarget(edge), this.getSource(edge));
            }
            return e;
        }
        catch (GraphException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GraphException(e);
        }
    }

    public boolean hasConnection(Vertex start, Vertex end) throws GraphException {
        if (start == end) {
            return true;
        }
        try {
            if (this.allPaths == null) {
                this.allPaths = new AllPairsShortestPath(this);
            } else {
                this.allPaths.update(this);
            }
            WeightedPath path = this.allPaths.getShortestPath(start, end);
        }
        catch (GraphException ex) {
            return false;
        }
        return true;
    }

    public MinimumSpanningForest minimumSpanningForest() {
        return new MinimumSpanningForest(this);
    }

    public MinimumSpanningForest maximumSpanningForest() {
        return new MinimumSpanningForest(false, this);
    }
}

