/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.algorithm.path;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.graph.DirectedGraph;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.WeightedPath;
import org.apache.commons.graph.exception.GraphException;
import org.apache.commons.graph.exception.NegativeCycleException;
import org.apache.commons.graph.exception.NoPathException;

public class AllPairsShortestPath {
    private int[][] pred;
    private double[][] cost;
    private Vertex[] vArray;
    private DirectedGraph graph;
    private Map vertexIndex = new HashMap();

    public AllPairsShortestPath(DirectedGraph graph) throws NegativeCycleException {
        this.update(graph);
    }

    private void initIndex(Vertex[] vArray) {
        int i = 0;
        while (i < vArray.length) {
            this.vertexIndex.put(vArray[i], new Integer(i));
            ++i;
        }
    }

    public void update(DirectedGraph graph) {
        this.graph = graph;
        Set vertexSet = graph.getVertices();
        this.vArray = vertexSet.toArray(new Vertex[vertexSet.size()]);
        this.initIndex(this.vArray);
        this.pred = new int[this.vArray.length][this.vArray.length];
        this.cost = new double[this.vArray.length][this.vArray.length];
        int i = 0;
        while (i < this.vArray.length) {
            int j = 0;
            while (j < this.vArray.length) {
                this.pred[i][j] = -1;
                this.cost[i][j] = Double.POSITIVE_INFINITY;
                ++j;
            }
            Iterator edgeSet = graph.getOutbound(this.vArray[i]).iterator();
            while (edgeSet.hasNext()) {
                Edge e = (Edge)edgeSet.next();
                int j2 = this.index(graph.getTarget(e));
                this.pred[i][j2] = i;
                this.cost[i][j2] = graph instanceof WeightedGraph ? ((WeightedGraph)((Object)graph)).getWeight(e) : 1.0;
            }
            this.cost[i][i] = 0.0;
            this.pred[i][i] = i;
            ++i;
        }
        this.compute(graph, this.vArray);
    }

    private int index(Vertex v) {
        return (Integer)this.vertexIndex.get(v);
    }

    private void compute(DirectedGraph graph, Vertex[] vArray) throws NegativeCycleException {
        int k = 0;
        while (k < vArray.length) {
            int i = 0;
            while (i < vArray.length) {
                int j = 0;
                while (j < vArray.length) {
                    if (this.cost[i][k] + this.cost[k][j] < this.cost[i][j]) {
                        if (i == j) {
                            throw new NegativeCycleException();
                        }
                        this.cost[i][j] = this.cost[i][k] + this.cost[k][j];
                        this.pred[i][j] = k;
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    public WeightedPath getShortestPath(Vertex start, Vertex end) throws GraphException {
        return new WPath(this.graph, this.vArray, this.pred, this.index(start), this.index(end), this.cost[this.index(start)][this.index(end)]);
    }

    public boolean hasPath(Vertex start, Vertex end) {
        return this.cost[this.index(start)][this.index(end)] < Double.POSITIVE_INFINITY;
    }

    public class WPath
    implements WeightedPath {
        private Vertex start;
        private Vertex finish;
        private List vertexList = new ArrayList();
        private DirectedGraph graph;
        private double cost;

        public WPath(DirectedGraph graph, Vertex[] vArray, int[][] pred, int start, int finish, double cost) throws GraphException {
            this.start = vArray[start];
            this.finish = vArray[finish];
            this.cost = cost;
            this.graph = graph;
            this.vertexList.addAll(this.segment(vArray, pred, start, finish));
            this.vertexList.add(vArray[finish]);
        }

        private List segment(Vertex[] vArray, int[][] pred, int start, int finish) throws GraphException {
            int mid = pred[start][finish];
            if (mid == -1) {
                throw new NoPathException("No SubPath Available: " + vArray[start] + " -> " + vArray[finish]);
            }
            ArrayList<Vertex> RC = new ArrayList<Vertex>();
            if (start == finish) {
                return RC;
            }
            if (start == mid) {
                RC.add(vArray[start]);
            } else {
                RC.addAll(this.segment(vArray, pred, start, mid));
                RC.add(vArray[mid]);
            }
            if (mid != pred[mid][finish]) {
                RC.addAll(this.segment(vArray, pred, mid, finish));
            }
            return RC;
        }

        public double getWeight() {
            return this.cost;
        }

        public List getVertices() {
            return this.vertexList;
        }

        public List getEdges() {
            return new EdgeList(this.graph, this.vertexList);
        }

        public Vertex getStart() {
            return this.start;
        }

        public Vertex getEnd() {
            return this.finish;
        }

        public int size() {
            return this.vertexList.size();
        }
    }

    public class EdgeList
    extends AbstractList {
        private DirectedGraph graph;
        private List vertices;

        public EdgeList(DirectedGraph graph, List vertices) {
            this.graph = graph;
            this.vertices = vertices;
        }

        public int size() {
            return this.vertices.size() - 1;
        }

        public Object get(int index) {
            Edge RC = null;
            Vertex source = (Vertex)this.vertices.get(index);
            Vertex target = (Vertex)this.vertices.get(index + 1);
            Set outboundSet = this.graph.getOutbound(source);
            if (outboundSet == null) {
                return null;
            }
            Iterator outbound = outboundSet.iterator();
            while (outbound.hasNext()) {
                RC = (Edge)outbound.next();
                if (this.graph.getTarget(RC) == target) break;
            }
            if (this.graph.getTarget(RC) != target) {
                return null;
            }
            return RC;
        }
    }
}

