/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.ArtifactListBuilder;
import org.apache.maven.DependencyClasspathBuilder;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.BaseObject;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Organization;
import org.apache.maven.project.PackageGroup;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Version;
import org.apache.maven.util.StringTool;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.maven.verifier.DependencyVerifier;
import org.apache.maven.verifier.RepoConfigException;
import org.apache.maven.verifier.UnsatisfiedDependencyException;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class Project
extends BaseObject {
    private List dependencies;
    private Repository repository;
    private Build build;
    private String url;
    private String logo;
    private String description;
    private String issueTrackingUrl;
    private List mailingLists;
    private List developers;
    private List contributors;
    private List licenses;
    private String currentVersion;
    private Organization organization;
    private String inceptionYear;
    private String projectPackage;
    private String siteAddress;
    private String siteDirectory;
    private String distributionSite;
    private String distributionDirectory;
    private String pomVersion;
    private List versions;
    private List branches;
    private HashMap versionMap;
    private String pomToExtend;
    private Project parent;
    private String gumpRepositoryId;
    private String shortDescription;
    private String groupId;
    private File file;
    private Map dependencyPaths;
    private Map dependencyMap;
    private List artifactList;
    private List reports;
    private MavenJellyContext context;
    private List contextStack = new ArrayList();
    private List packageGroups;
    private String artifactId;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$project$Project == null ? (class$org$apache$maven$project$Project = Project.class$("org.apache.maven.project.Project")) : class$org$apache$maven$project$Project));
    private File mavenXml;
    private boolean initialized = false;
    private DependencyVerifier dependencyVerifier;
    private String dependencyClasspath;
    static /* synthetic */ Class class$org$apache$maven$project$Project;

    public Project() {
        this.dependencies = new ArrayList();
        this.mailingLists = new ArrayList();
        this.developers = new ArrayList();
        this.contributors = new ArrayList();
        this.licenses = new ArrayList();
        this.versions = new ArrayList();
        this.branches = new ArrayList();
        this.dependencyPaths = new HashMap();
        this.dependencyMap = new HashMap();
        this.reports = new ArrayList();
        this.packageGroups = new ArrayList();
    }

    public File getMavenXml() {
        if (this.mavenXml == null && this.getFile() != null) {
            this.mavenXml = new File(this.getFile().getParentFile(), "maven.xml");
        }
        return this.mavenXml;
    }

    public boolean hasMavenXml() {
        return this.getMavenXml().exists();
    }

    public String getId() {
        if (this.id != null && this.id.indexOf(":") > 0) {
            return this.id;
        }
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = StringTool.trim(artifactId);
    }

    public String getArtifactId() {
        if (!this.isValid(this.artifactId)) {
            this.artifactId = this.id;
        }
        return this.artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = StringTool.trim(groupId);
    }

    public String getGroupId() {
        if (this.groupId == null) {
            this.groupId = this.getArtifactId();
        }
        return this.groupId;
    }

    public MavenJellyContext getPluginContext(String pluginId) throws Exception {
        PluginManager pluginManager = this.context.getMavenSession().getPluginManager();
        return pluginManager.getPluginContext(pluginId);
    }

    public void setContext(MavenJellyContext context) {
        if (this.contextStack.size() > 0) {
            log.warn((Object)"replacing a context when the stack is not empty");
        }
        this.context = context;
    }

    public void pushContext(MavenJellyContext context) {
        this.contextStack.add(this.context);
        this.context = context;
    }

    public void popContext() {
        MavenJellyContext context = (MavenJellyContext)((Object)this.contextStack.get(this.contextStack.size() - 1));
        this.contextStack.remove(this.contextStack.size() - 1);
        this.context = context;
    }

    public MavenJellyContext getContext() {
        return this.context;
    }

    public void setArtifacts(List artifactList) {
        this.artifactList = artifactList;
    }

    public List getArtifacts() {
        return this.artifactList;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setExtend(String pomToExtend) {
        this.pomToExtend = StringTool.trim(pomToExtend);
    }

    public String getExtend() {
        return this.pomToExtend;
    }

    public Project getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void setParent(Project parent) {
        this.parent = parent;
    }

    public File parentBasedir() {
        return new File(this.getExtend()).getParentFile();
    }

    public File parentMavenXml() {
        return new File(this.parentBasedir(), "maven.xml");
    }

    public void setGumpRepositoryId(String gumpRepositoryId) {
        this.gumpRepositoryId = StringTool.trim(gumpRepositoryId);
    }

    public String getGumpRepositoryId() {
        return this.gumpRepositoryId;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getArtifactDirectory() {
        if (this.isValid(this.getGroupId())) {
            return this.getGroupId();
        }
        return Project.standardToLegacyId(this.getId());
    }

    public void setSiteAddress(String siteAddress) {
        this.siteAddress = StringTool.trim(siteAddress);
    }

    public String getSiteAddress() {
        return this.siteAddress;
    }

    public void setSiteDirectory(String siteDirectory) {
        this.siteDirectory = StringTool.trim(siteDirectory);
    }

    public String getSiteDirectory() {
        return this.siteDirectory;
    }

    public void setDistributionSite(String distributionSite) {
        this.distributionSite = StringTool.trim(distributionSite);
    }

    public String getDistributionSite() {
        return this.distributionSite;
    }

    public void setDistributionDirectory(String distributionDirectory) {
        this.distributionDirectory = StringTool.trim(distributionDirectory);
    }

    public String getDistributionDirectory() {
        return this.distributionDirectory;
    }

    public void addDependency(Dependency dependency) {
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
            this.dependencyMap.put(dependency.getId(), dependency);
        }
    }

    public void setDependencies(List dependencies) {
        this.dependencies = dependencies;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    static void mergeLists(List srcList, List targetList) {
        if (srcList != null) {
            Iterator i = srcList.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (targetList.contains(o)) continue;
                targetList.add(o);
            }
        }
    }

    private void addParentDependencies(List dependencies) {
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            this.addDependency((Dependency)i.next());
        }
    }

    private void addParentVersions(List versions) {
        Iterator i = versions.iterator();
        while (i.hasNext()) {
            this.addVersion((Version)i.next());
        }
    }

    public Set getDependentProjectIds() {
        TreeSet<String> projectIds = new TreeSet<String>();
        List dependencies = this.getDependencies();
        int i = 0;
        while (i < dependencies.size()) {
            Dependency dependency = (Dependency)dependencies.get(i);
            projectIds.add(dependency.getId());
            ++i;
        }
        return projectIds;
    }

    public void setDependencyPath(String depId, String path) {
        this.dependencyPaths.put(depId, path);
    }

    public String getDependencyPath(String depId) {
        return (String)this.dependencyPaths.get(Project.legacyToStandardId(depId));
    }

    public Dependency getDependency(String depId) {
        return (Dependency)this.dependencyMap.get(Project.legacyToStandardId(depId));
    }

    public void addReport(String report) {
        String reportName = StringTool.trim(report);
        if (!this.reports.contains(reportName)) {
            this.reports.add(reportName);
        }
    }

    public void setReports(List reports) {
        this.reports = reports;
    }

    public List getReports() {
        return this.reports;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public Build getBuild() {
        return this.build;
    }

    public void addMailingList(MailingList mailingList) {
        this.mailingLists.add(mailingList);
    }

    public void setMailingLists(List mailingLists) {
        this.mailingLists = mailingLists;
    }

    public List getMailingLists() {
        return this.mailingLists;
    }

    public void addDeveloper(Developer developer) {
        this.developers.add(developer);
    }

    public void setDevelopers(List developers) {
        this.developers = developers;
    }

    public List getDevelopers() {
        return this.developers;
    }

    public void setContributors(List contributors) {
        this.contributors = contributors;
    }

    public void addContributor(Contributor contributor) {
        this.contributors.add(contributor);
    }

    public List getContributors() {
        return this.contributors;
    }

    public void setLicenses(List licenses) {
        this.licenses = licenses;
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    public List getLicenses() {
        return this.licenses;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setUrl(String url) {
        this.url = StringTool.trim(url);
    }

    public String getUrl() {
        return this.url;
    }

    public void setIssueTrackingUrl(String issueTrackingUrl) {
        this.issueTrackingUrl = StringTool.trim(issueTrackingUrl);
    }

    public String getIssueTrackingUrl() {
        return this.issueTrackingUrl;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasRepository() {
        return this.repository != null;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = StringTool.trim(currentVersion);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setPackage(String projectPackage) {
        this.projectPackage = StringTool.trim(projectPackage);
    }

    public String getPackage() {
        return this.projectPackage;
    }

    public void setInceptionYear(String inceptionYear) {
        this.inceptionYear = StringTool.trim(inceptionYear);
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public void setPomVersion(String pomVersion) {
        this.pomVersion = StringTool.trim(pomVersion);
    }

    public String getPomVersion() {
        if (this.pomVersion == null) {
            this.pomVersion = "1";
        }
        return this.pomVersion;
    }

    public boolean isPomCurrent() {
        return Integer.parseInt(this.getPomVersion()) == 3;
    }

    public void addVersion(Version version) {
        if (this.versionMap != null) {
            this.versionMap.put(version.getId(), version);
        }
        this.versions.add(version);
    }

    public void setVersions(List versions) {
        this.versions = versions;
        this.versionMap = null;
    }

    public List getVersions() {
        return this.versions;
    }

    public void addBranch(Branch branch) {
        this.branches.add(branch);
    }

    public void setBranches(List branches) {
        this.branches = branches;
    }

    public List getBranches() {
        return this.branches;
    }

    public Version getVersionById(String versionId) {
        if (this.versionMap == null) {
            this.versionMap = new HashMap();
            Iterator i = this.versions.iterator();
            while (i.hasNext()) {
                Version version = (Version)i.next();
                this.versionMap.put(version.getId(), version);
            }
        }
        return (Version)this.versionMap.get(versionId);
    }

    public void setLogo(String logo) {
        this.logo = StringTool.trim(logo);
    }

    public String getLogo() {
        return this.logo;
    }

    public List getPackageGroups() {
        return this.packageGroups;
    }

    public void setPackageGroups(List packageGroups) {
        this.packageGroups = packageGroups;
    }

    public void addPackageGroup(PackageGroup packageGroup) {
        this.packageGroups.add(packageGroup);
    }

    public Document createDocument() throws Exception {
        SAXReader reader = new SAXReader();
        return reader.read((Reader)new InputStreamReader(MavenUtils.getProjectInputStream(this)));
    }

    public void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        this.buildArtifactList();
        this.dependencyClasspath = DependencyClasspathBuilder.build(this);
        this.setDependencyVerifier(new DependencyVerifier(this));
        this.getDependencyVerifier().setIgnoreErrors(false);
        if (this.build != null) {
            this.build.resolveDirectories(this.file.getParentFile());
        }
        this.initialized = true;
    }

    public void verifyDependencies() throws RepoConfigException, UnsatisfiedDependencyException, ChecksumVerificationException {
        if (this.getFile() != null && this.getFile().exists() && this.initialized) {
            this.getDependencyVerifier().verify();
        }
    }

    public void setDependencyVerifier(DependencyVerifier dependencyVerifier) {
        this.dependencyVerifier = dependencyVerifier;
    }

    public DependencyVerifier getDependencyVerifier() {
        return this.dependencyVerifier;
    }

    public String getDependencyClasspath() {
        return this.dependencyClasspath;
    }

    public void buildArtifactList() {
        this.artifactList = ArtifactListBuilder.build(this);
    }

    public static String legacyToStandardId(String id) {
        String newId = id;
        if (id.indexOf("+") != -1) {
            int plusPos = id.indexOf("+");
            String groupId = id.substring(0, plusPos);
            String partialArtifactId = id.substring(plusPos + 1);
            newId = groupId + ":" + groupId + "-" + partialArtifactId;
        } else if (id.indexOf(":") == -1) {
            newId = newId + ":" + id;
        }
        return newId;
    }

    public static String standardToLegacyId(String id) {
        int i = id.indexOf(":");
        if (i > 0) {
            id = id.substring(i + 1);
        }
        return id;
    }

    public void mergeParent(Project parent) {
        this.setParent(parent);
        if (parent == null) {
            return;
        }
        if (this.repository == null) {
            this.repository = parent.repository;
        }
        if (this.getName() == null) {
            this.setName(parent.getName());
        }
        if (this.url == null) {
            this.url = parent.url;
        }
        if (this.logo == null) {
            this.logo = parent.logo;
        }
        if (this.description == null) {
            this.description = parent.description;
        }
        if (this.issueTrackingUrl == null) {
            this.issueTrackingUrl = parent.issueTrackingUrl;
        }
        if (this.currentVersion == null) {
            this.currentVersion = parent.currentVersion;
        }
        if (this.organization == null) {
            this.organization = parent.organization;
        }
        if (this.inceptionYear == null) {
            this.inceptionYear = parent.inceptionYear;
        }
        if (this.projectPackage == null) {
            this.projectPackage = parent.projectPackage;
        }
        if (this.siteAddress == null) {
            this.siteAddress = parent.siteAddress;
        }
        if (this.siteDirectory == null) {
            this.siteDirectory = parent.siteDirectory;
        }
        if (this.distributionSite == null) {
            this.distributionSite = parent.distributionSite;
        }
        if (this.distributionDirectory == null) {
            this.distributionDirectory = parent.distributionDirectory;
        }
        if (this.pomVersion == null) {
            this.pomVersion = parent.pomVersion;
        }
        if (this.gumpRepositoryId == null) {
            this.gumpRepositoryId = parent.gumpRepositoryId;
        }
        if (this.shortDescription == null) {
            this.shortDescription = parent.shortDescription;
        }
        if (this.groupId == null) {
            this.groupId = parent.groupId;
        }
        if (this.build == null) {
            this.build = new Build();
            this.build.mergeParent(parent.build);
        } else {
            this.build.mergeParent(parent.build);
        }
        if (this.mailingLists == null || this.mailingLists.isEmpty()) {
            this.mailingLists = parent.mailingLists;
        }
        if (this.contributors == null || this.contributors.isEmpty()) {
            this.contributors = parent.contributors;
        }
        if (this.developers == null || this.developers.isEmpty()) {
            this.developers = parent.developers;
        }
        if (this.versions == null || this.versions.isEmpty()) {
            this.setVersions(parent.versions);
        }
        if (this.licenses == null || this.licenses.isEmpty()) {
            this.licenses = parent.licenses;
        }
        if (this.branches == null || this.branches.isEmpty()) {
            this.branches = parent.branches;
        }
        if (this.reports == null || this.reports.isEmpty()) {
            this.reports = parent.reports;
        }
        if (this.packageGroups == null || this.packageGroups.isEmpty()) {
            this.packageGroups = parent.packageGroups;
        }
        this.addParentDependencies(parent.dependencies);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

