/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.MavenUtils;
import org.apache.maven.project.BaseObject;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.util.StringTool;

public class Build
extends BaseObject {
    private String sourceDirectory;
    private String aspectSourceDirectory;
    private String unitTestSourceDirectory;
    private String integrationUnitTestSourceDirectory;
    private String nagEmailAddress;
    private UnitTest unitTest;
    private List sourceModifications = new ArrayList();
    private List resources = new ArrayList();

    public String getIntegrationUnitTestSourceDirectory() {
        return this.integrationUnitTestSourceDirectory;
    }

    public void setIntegrationUnitTestSourceDirectory(String utDirectory) {
        this.integrationUnitTestSourceDirectory = StringTool.trim(utDirectory);
    }

    public String getUnitTestSourceDirectory() {
        return this.unitTestSourceDirectory;
    }

    public void setUnitTestSourceDirectory(String utDirectory) {
        this.unitTestSourceDirectory = StringTool.trim(utDirectory);
    }

    public void addSourceModification(SourceModification sourceModification) {
        this.sourceModifications.add(sourceModification);
    }

    public void setSourceModification(List sourceModifications) {
        this.sourceModifications = sourceModifications;
    }

    public List getSourceModifications() {
        return this.sourceModifications;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = StringTool.trim(sourceDirectory);
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setAspectSourceDirectory(String aspectSourceDirectory) {
        this.aspectSourceDirectory = StringTool.trim(aspectSourceDirectory);
    }

    public String getAspectSourceDirectory() {
        return this.aspectSourceDirectory;
    }

    public void setNagEmailAddress(String nagEmailAddress) {
        this.nagEmailAddress = StringTool.trim(nagEmailAddress);
    }

    public String getNagEmailAddress() {
        return this.nagEmailAddress;
    }

    public void setUnitTest(UnitTest unitTest) {
        this.unitTest = unitTest;
    }

    public UnitTest getUnitTest() {
        return this.unitTest;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public void setResources(List resources) {
        this.resources = resources;
    }

    public List getResources() {
        return this.resources;
    }

    public String toString() {
        return "[ sourceDirectory = " + this.getSourceDirectory() + ", unitTestSourceDirectory = " + this.getUnitTestSourceDirectory() + " ]";
    }

    public void resolveDirectories(File basedir) throws IOException {
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            r.resolveDirectory(basedir);
        }
        if (this.unitTest != null) {
            Iterator i2 = this.unitTest.getResources().iterator();
            while (i2.hasNext()) {
                Resource r = (Resource)i2.next();
                r.resolveDirectory(basedir);
            }
        }
        if (this.sourceDirectory != null && this.sourceDirectory.length() > 0) {
            this.sourceDirectory = MavenUtils.makeAbsolutePath(basedir, this.sourceDirectory);
        }
        if (this.aspectSourceDirectory != null && this.aspectSourceDirectory.length() > 0) {
            this.aspectSourceDirectory = MavenUtils.makeAbsolutePath(basedir, this.aspectSourceDirectory);
        }
        if (this.unitTestSourceDirectory != null && this.unitTestSourceDirectory.length() > 0) {
            this.unitTestSourceDirectory = MavenUtils.makeAbsolutePath(basedir, this.unitTestSourceDirectory);
        }
        if (this.integrationUnitTestSourceDirectory != null && this.integrationUnitTestSourceDirectory.length() > 0) {
            this.integrationUnitTestSourceDirectory = MavenUtils.makeAbsolutePath(basedir, this.integrationUnitTestSourceDirectory);
        }
    }

    void mergeParent(Build parent) {
        if (parent == null) {
            return;
        }
        if (this.sourceDirectory == null) {
            this.sourceDirectory = parent.sourceDirectory;
        }
        if (this.unitTestSourceDirectory == null) {
            this.unitTestSourceDirectory = parent.unitTestSourceDirectory;
        }
        if (this.integrationUnitTestSourceDirectory == null) {
            this.integrationUnitTestSourceDirectory = parent.integrationUnitTestSourceDirectory;
        }
        if (this.aspectSourceDirectory == null) {
            this.aspectSourceDirectory = parent.aspectSourceDirectory;
        }
        if (this.nagEmailAddress == null) {
            this.nagEmailAddress = parent.nagEmailAddress;
        }
        if (this.resources == null || this.resources.isEmpty()) {
            this.resources = parent.resources;
        }
        if (this.sourceModifications == null || this.sourceModifications.isEmpty()) {
            this.sourceModifications = parent.sourceModifications;
        }
        if (this.unitTest == null) {
            this.unitTest = parent.unitTest;
        } else {
            this.unitTest.mergeParent(parent.unitTest);
        }
    }
}

