/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import com.werken.forehead.Forehead;
import com.werken.forehead.ForeheadClassLoader;
import com.werken.werkz.Session;
import com.werken.werkz.WerkzProject;
import com.werken.werkz.jelly.JellySession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.AntProjectBuilder;
import org.apache.maven.MavenException;
import org.apache.maven.MavenSession;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.JellyUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.GoalToJellyScriptHousingMapper;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginCacheManager;
import org.apache.maven.plugin.UnknownPluginException;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.apache.maven.util.Expand;

public class PluginManager
extends AbstractMavenComponent {
    private static final String ROOT_MAVEN_CLASSLOADER = "root.maven";
    private static final String PLUGIN_PROPERTIES_NAME = "plugin.properties";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$PluginManager == null ? (class$org$apache$maven$plugin$PluginManager = PluginManager.class$("org.apache.maven.plugin.PluginManager")) : class$org$apache$maven$plugin$PluginManager));
    public static final String GLOBAL_SESSION_KEY = "maven.session.global";
    public static final String PLUGIN_MANAGER = "maven.plugin.manager";
    public static final String GOAL_MAPPER = "maven.plugin.mapper";
    public static final String BASE_CONTEXT = "maven.goalAttainmentContext";
    private File pluginsDir;
    private File unpackedPluginsDir;
    private final Map pluginHousings = new HashMap();
    private final Map artifactIdToHousingMap = new HashMap();
    private MavenSession mavenSession;
    private final PluginCacheManager cacheManager = new PluginCacheManager();
    private final GoalToJellyScriptHousingMapper mapper = new GoalToJellyScriptHousingMapper();
    private Set delayedPops = new HashSet();
    static /* synthetic */ Class class$org$apache$maven$plugin$PluginManager;

    public PluginManager(MavenSession session) {
        this.mavenSession = session;
    }

    private void expandPluginJars(File directory) throws MavenException {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            this.unpackPlugin(files[i]);
            ++i;
        }
    }

    private void loadUnpackedPlugins(File directory) throws Exception {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        boolean loadedNewPlugins = false;
        int i = 0;
        while (i < files.length) {
            File pluginDir = files[i];
            if (pluginDir.isDirectory() && new File(pluginDir, "project.xml").exists() && !this.isLoaded(pluginDir.getName())) {
                loadedNewPlugins = true;
                JellyScriptHousing housing = this.loadPlugin(pluginDir);
                housing.parse(this.cacheManager);
                housing.parse(this.mapper);
            }
            ++i;
        }
        if (loadedNewPlugins) {
            this.cacheManager.saveCache(this.unpackedPluginsDir);
        }
    }

    public void initialize() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Plugins!");
        }
        this.setPluginsDir(new File(this.mavenSession.getRootContext().getMavenHome(), "plugins"));
        this.setUnpackedPluginsDir(new File(this.mavenSession.getRootContext().getUnpackedPluginsDir()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set plugin source directory to " + this.getPluginsDir().getAbsolutePath()));
            log.debug((Object)("Set unpacked plugin directory to " + this.getUnpackedPluginsDir().getAbsolutePath()));
        }
        this.cacheManager.loadCache(this.unpackedPluginsDir);
        this.cacheManager.mapPlugins(this.mapper, this);
        this.expandPluginJars(this.pluginsDir);
        this.expandPluginJars(this.unpackedPluginsDir);
        this.loadUnpackedPlugins(this.pluginsDir);
        this.loadUnpackedPlugins(this.unpackedPluginsDir);
        log.debug((Object)"Finished initializing Plugins!");
    }

    JellyScriptHousing loadPlugin(String pluginName) throws Exception {
        return this.loadPlugin(new File(this.unpackedPluginsDir, pluginName));
    }

    private JellyScriptHousing loadPlugin(File pluginDir) throws Exception {
        String pluginName = pluginDir.getName();
        if (!this.isLoaded(pluginName)) {
            log.debug((Object)("Loading plugin '" + pluginName + "'"));
            JellyScriptHousing jellyScriptHousing = new JellyScriptHousing(pluginDir, this.mavenSession.getRootContext());
            this.pluginHousings.put(pluginName, jellyScriptHousing);
            return jellyScriptHousing;
        }
        log.debug((Object)("Skipping already loaded plugin '" + pluginName + "'"));
        return (JellyScriptHousing)this.pluginHousings.get(pluginName);
    }

    private boolean isLoaded(String name) {
        return this.pluginHousings.containsKey(name);
    }

    private JellyScriptHousing createJellyScriptHousing(Project project, InputStream jelly) throws Exception {
        JellyScriptHousing jellyScriptHousing = new JellyScriptHousing();
        Script script = JellyUtils.compileScript(jelly, (JellyContext)project.getContext());
        jellyScriptHousing.setProject(project);
        jellyScriptHousing.setScript(script);
        return jellyScriptHousing;
    }

    private JellyScriptHousing createJellyScriptHousing(Project project, File jelly) throws Exception {
        JellyScriptHousing jellyScriptHousing = new JellyScriptHousing();
        jellyScriptHousing.setProject(project);
        jellyScriptHousing.setSource(jelly);
        return jellyScriptHousing;
    }

    public void processDependencies(Project project) throws MalformedURLException, Exception {
        if (project.getArtifacts() == null) {
            log.debug((Object)("No dependencies to process for project " + project.getName()));
            return;
        }
        ForeheadClassLoader projectClassLoader = (ForeheadClassLoader)project.getContext().getClassLoader();
        log.debug((Object)("Processing dependencies for project " + project.getName() + "; classloader " + projectClassLoader));
        Iterator i = project.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            Dependency dependency = artifact.getDependency();
            if (dependency.isPlugin()) {
                this.installPlugin(artifact.getFile(), project);
            }
            String dependencyClassLoader = dependency.getProperty("classloader");
            if (artifact.exists()) {
                if (dependency.isAddedToClasspath()) {
                    if (dependencyClassLoader != null) {
                        log.debug((Object)("DEPRECATION: " + dependency.getId() + " in project " + project.getId() + " forces the classloader '" + dependencyClassLoader + "'"));
                        log.debug((Object)"             This behaviour is deprecated. Please refer to the FAQ");
                        ForeheadClassLoader loader = Forehead.getInstance().getClassLoader(dependencyClassLoader);
                        if (loader == null) {
                            log.warn((Object)("classloader '" + dependencyClassLoader + "' not found. Adding dependencies to the project classloader instead"));
                            loader = projectClassLoader;
                        } else {
                            log.debug((Object)("poking dependency " + artifact.getFile() + " into classloader " + dependencyClassLoader));
                        }
                        loader.addURL(artifact.getFile().toURL());
                        continue;
                    }
                    projectClassLoader.addURL(artifact.getFile().toURL());
                    continue;
                }
                log.debug((Object)("Non classpath dependency: '" + artifact.getFile() + "' not added to classpath"));
                continue;
            }
            log.info((Object)("Artifact '" + artifact.getFile() + "' not found to add to classpath"));
        }
        project.getContext().setClassLoader((ClassLoader)projectClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attainGoals(Project project, List goals) throws Exception {
        String defaultGoalName;
        MavenJellyContext baseContext = new MavenJellyContext(this.mavenSession.getRootContext());
        baseContext.setInherit(true);
        baseContext.setVariables(project.getContext().getVariables());
        baseContext.setVariable("context", (Object)baseContext);
        project.pushContext(baseContext);
        baseContext.setProject(project);
        project.verifyDependencies();
        AntProjectBuilder.build(project, baseContext);
        GoalToJellyScriptHousingMapper transientMapper = new GoalToJellyScriptHousingMapper();
        JellySession session = new JellySession(baseContext.getXMLOutput());
        session.setAttribute(BASE_CONTEXT, (Object)baseContext);
        session.setAttribute(PLUGIN_MANAGER, (Object)this);
        session.setAttribute(GOAL_MAPPER, (Object)transientMapper);
        baseContext.setVariable(GLOBAL_SESSION_KEY, session);
        ArrayList<JellyScriptHousing> projectHousings = new ArrayList<JellyScriptHousing>();
        InputStream driver = this.getClass().getResourceAsStream("/driver.jelly");
        JellyScriptHousing driverHousing = this.createJellyScriptHousing(project, driver);
        driver.close();
        driver = this.getClass().getResourceAsStream("/driver.jelly");
        driverHousing.parse(transientMapper, driver);
        driver.close();
        Project p = project;
        while (p != null) {
            if (p.hasMavenXml()) {
                File mavenXml = p.getMavenXml();
                JellyScriptHousing jellyScriptHousing = this.createJellyScriptHousing(project, mavenXml);
                jellyScriptHousing.parse(transientMapper);
                projectHousings.add(jellyScriptHousing);
            }
            p = p.getParent();
        }
        if (goals != null && goals.size() == 0 && (defaultGoalName = transientMapper.getDefaultGoalName()) != null) {
            log.debug((Object)("Using default goal: " + defaultGoalName));
            goals.add(defaultGoalName);
        }
        if (goals == null) {
            goals = Collections.EMPTY_LIST;
        } else {
            goals.add(0, "build:start");
            goals.add("build:end");
        }
        transientMapper.merge(this.mapper);
        WerkzProject werkzProject = new WerkzProject();
        baseContext.setWerkzProject(werkzProject);
        HashSet pluginSet = new HashSet();
        HashSet oldDelayedPops = new HashSet(this.delayedPops);
        this.delayedPops.clear();
        Thread.currentThread().setContextClassLoader(null);
        try {
            this.runScript(driverHousing, baseContext);
            transientMapper.addResolvedPlugins(Collections.singletonList(driverHousing));
            this.processDependencies(project);
            Iterator j = projectHousings.iterator();
            while (j.hasNext()) {
                JellyScriptHousing housing = (JellyScriptHousing)j.next();
                this.runScript(housing, baseContext);
            }
            transientMapper.addResolvedPlugins(projectHousings);
            Iterator i = goals.iterator();
            while (i.hasNext()) {
                String goalName = (String)i.next();
                pluginSet.addAll(this.prepAttainGoal(goalName, baseContext, transientMapper));
            }
            Iterator i2 = goals.iterator();
            while (i2.hasNext()) {
                String goalName = (String)i2.next();
                log.debug((Object)("attaining goal " + goalName));
                werkzProject.attainGoal(goalName, (Session)session);
            }
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            this.cleanupAttainGoal(pluginSet);
            this.delayedPops = oldDelayedPops;
            project.popContext();
            throw throwable;
        }
        this.cleanupAttainGoal(pluginSet);
        this.delayedPops = oldDelayedPops;
        project.popContext();
    }

    public void cleanupAttainGoal(Set pluginSet) throws Exception {
        this.delayedPops.addAll(pluginSet);
        Iterator j = this.delayedPops.iterator();
        while (j.hasNext()) {
            JellyScriptHousing housing = (JellyScriptHousing)j.next();
            housing.getProject().popContext();
        }
        this.delayedPops.clear();
    }

    public Set prepAttainGoal(String goalName, MavenJellyContext baseContext, GoalToJellyScriptHousingMapper goalMapper) throws Exception {
        Set pluginSet = goalMapper.resolveJellyScriptHousings(goalName);
        Iterator j = pluginSet.iterator();
        while (j.hasNext()) {
            JellyScriptHousing housing = (JellyScriptHousing)j.next();
            this.artifactIdToHousingMap.put(housing.getProject().getArtifactId(), housing);
            File pluginDirectory = housing.getPluginDirectory();
            MavenUtils.integrateMapInContext(this.getPluginProperties(pluginDirectory), baseContext);
            MavenJellyContext pluginContext = new MavenJellyContext(baseContext);
            housing.getProject().pushContext(pluginContext);
            pluginContext.setInherit(true);
            pluginContext.setVariable("context", (Object)pluginContext);
            pluginContext.setVariable("plugin", housing.getProject());
            pluginContext.setVariable("plugin.dir", pluginDirectory);
            pluginContext.setVariable("plugin.resources", new File(pluginDirectory, "plugin-resources"));
            this.runScript(housing, pluginContext);
        }
        return pluginSet;
    }

    private Properties getPluginProperties(File unpackedPluginDir) throws IOException {
        File propsFile = new File(unpackedPluginDir, PLUGIN_PROPERTIES_NAME);
        if (!propsFile.exists()) {
            return null;
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propsFile);
        props.load(in);
        in.close();
        return props;
    }

    private void setPluginsDir(File dir) {
        this.pluginsDir = dir;
    }

    private File getPluginsDir() {
        return this.pluginsDir;
    }

    private void setUnpackedPluginsDir(File dir) {
        this.unpackedPluginsDir = dir;
    }

    private File getUnpackedPluginsDir() {
        return this.unpackedPluginsDir;
    }

    public Set getGoalNames() {
        return this.mapper.getGoalNames();
    }

    public void installPlugin(File file, Project parentProject) throws Exception {
        this.installPlugin(file, parentProject, false);
    }

    public void installPlugin(File file, Project parentProject, boolean installToUnpackedPluginDirectory) throws Exception {
        if (installToUnpackedPluginDirectory) {
            FileUtils.copyFileToDirectory((File)file, (File)this.unpackedPluginsDir);
        }
        String pluginName = file.getCanonicalFile().getName();
        if (!this.isLoaded(pluginName = pluginName.substring(0, pluginName.indexOf(".jar")))) {
            File unpackedPluginDir = this.unpackPlugin(file);
            if (unpackedPluginDir != null) {
                JellyScriptHousing housing = this.loadPlugin(unpackedPluginDir);
                housing.parse(this.cacheManager);
                housing.parse(this.mapper);
                this.cacheManager.saveCache(this.unpackedPluginsDir);
            } else {
                throw new MavenException("Not a valid plugin file: " + file);
            }
        }
    }

    public MavenJellyContext getPluginContext(String id) throws Exception {
        JellyScriptHousing housing = (JellyScriptHousing)this.artifactIdToHousingMap.get(id);
        if (housing != null) {
            return housing.getProject().getContext();
        }
        throw new UnknownPluginException(id);
    }

    public String getGoalDescription(String goalName) {
        return this.mapper.getGoalDescription(goalName);
    }

    public void addDelayedPops(Set set) {
        this.delayedPops.addAll(set);
    }

    File unpackPlugin(File jarFile) throws MavenException {
        String directory = jarFile.getName();
        int index = directory.indexOf(".jar");
        if (index < 0) {
            return null;
        }
        String pluginName = directory.substring(0, index);
        File unzipDir = new File(this.unpackedPluginsDir, pluginName);
        if (!unzipDir.exists() || jarFile.lastModified() > unzipDir.lastModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unpacking '" + pluginName + "' plugin to directory --> " + unzipDir.getAbsolutePath()));
            }
            this.cacheManager.invalidateCache(pluginName);
            try {
                Expand unzipper = new Expand();
                unzipper.setSrc(jarFile);
                unzipper.setDest(unzipDir);
                unzipper.execute();
            }
            catch (IOException e) {
                throw new MavenException("Unable to extract plugin: " + jarFile, e);
            }
        }
        return unzipDir;
    }

    Map getPluginHousings() {
        return this.pluginHousings;
    }

    private Script loadScript(JellyScriptHousing jellyScriptHousing) throws Exception {
        if (jellyScriptHousing.getPluginDirectory() != null) {
            jellyScriptHousing.getProject().verifyDependencies();
            this.processDependencies(jellyScriptHousing.getProject());
            ForeheadClassLoader pluginClassLoader = (ForeheadClassLoader)jellyScriptHousing.getProject().getContext().getClassLoader();
            pluginClassLoader.addURL(jellyScriptHousing.getPluginDirectory().toURL());
        }
        MavenJellyContext context = jellyScriptHousing.getProject().getContext();
        URL oldRoot = context.getRootURL();
        URL oldCurrent = context.getCurrentURL();
        context.setRootURL(jellyScriptHousing.getSource().toURL());
        context.setCurrentURL(jellyScriptHousing.getSource().toURL());
        Script script = JellyUtils.compileScript(jellyScriptHousing.getSource(), (JellyContext)context);
        context.setRootURL(oldRoot);
        context.setCurrentURL(oldCurrent);
        return script;
    }

    void runScript(JellyScriptHousing jellyScriptHousing, MavenJellyContext context) throws Exception {
        log.debug((Object)("running script " + jellyScriptHousing.getSource()));
        Script s = jellyScriptHousing.getScript();
        if (s == null) {
            s = this.loadScript(jellyScriptHousing);
            jellyScriptHousing.setScript(s);
        }
        s.run((JellyContext)context, context.getXMLOutput());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

