/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.GoalToJellyScriptHousingMapper;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.apache.maven.plugin.PluginManager;

final class PluginCacheManager
implements PluginDefinitionHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$PluginCacheManager == null ? (class$org$apache$maven$plugin$PluginCacheManager = PluginCacheManager.class$("org.apache.maven.plugin.PluginCacheManager")) : class$org$apache$maven$plugin$PluginCacheManager));
    private static final Log sessionLog = LogFactory.getLog((Class)(class$org$apache$maven$MavenSession == null ? (class$org$apache$maven$MavenSession = PluginCacheManager.class$("org.apache.maven.MavenSession")) : class$org$apache$maven$MavenSession));
    public static final String PLUGINS_CACHE = "plugins.cache";
    public static final String GOALS_CACHE = "goals.cache";
    public static final String CALLBACKS_CACHE = "callbacks.cache";
    public static final String DYNAMIC_TAGLIBS_CACHE = "dynatag.cache";
    public static final String PLUGIN_DYNATAG_DEPS_CACHE = "plugin-dynatag-deps.cache";
    private Properties goalCache = new Properties();
    private Properties pluginCache = new Properties();
    private Properties dynaTagLibCache = new Properties();
    private Properties callbackCache = new Properties();
    private Properties pluginDynaTagDepsCache = new Properties();
    private Set pluginSet = new HashSet();
    static /* synthetic */ Class class$org$apache$maven$plugin$PluginCacheManager;
    static /* synthetic */ Class class$org$apache$maven$MavenSession;

    void saveCache(File directory) throws IOException {
        directory.mkdir();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving caches to " + directory.getAbsolutePath()));
        }
        this.storeProperties(this.pluginCache, new File(directory, PLUGINS_CACHE), "plugins cache");
        this.storeProperties(this.goalCache, new File(directory, GOALS_CACHE), "goals cache");
        this.storeProperties(this.callbackCache, new File(directory, CALLBACKS_CACHE), "callbacks cache");
        this.storeProperties(this.dynaTagLibCache, new File(directory, DYNAMIC_TAGLIBS_CACHE), "taglibs cache");
        this.storeProperties(this.pluginDynaTagDepsCache, new File(directory, PLUGIN_DYNATAG_DEPS_CACHE), "plugin deps cache");
    }

    private void storeProperties(Properties properties, File file, String header) throws FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(file);
        properties.store(stream, header);
        stream.close();
    }

    private Properties loadProperties(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                FileInputStream stream = new FileInputStream(file);
                properties.load(stream);
                stream.close();
            }
            catch (IOException e) {
                log.debug((Object)"IOException reading cache", (Throwable)e);
            }
        } else {
            log.debug((Object)("Cache file does not exist, skipping: " + file));
        }
        return properties;
    }

    void loadCache(File directory) {
        this.pluginCache = this.loadProperties(new File(directory, PLUGINS_CACHE));
        this.goalCache = this.loadProperties(new File(directory, GOALS_CACHE));
        this.callbackCache = this.loadProperties(new File(directory, CALLBACKS_CACHE));
        this.dynaTagLibCache = this.loadProperties(new File(directory, DYNAMIC_TAGLIBS_CACHE));
        this.pluginDynaTagDepsCache = this.loadProperties(new File(directory, PLUGIN_DYNATAG_DEPS_CACHE));
    }

    private void appendCsvProperty(Properties properties, String key, String newEntry) {
        String csvProperty = properties.getProperty(key);
        if (csvProperty == null) {
            properties.setProperty(key, newEntry);
        } else {
            StringTokenizer st = new StringTokenizer(csvProperty, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(newEntry)) continue;
                return;
            }
            properties.setProperty(key, csvProperty + ',' + newEntry);
        }
    }

    public void addPluginDynaTagDep(JellyScriptHousing housing, String uri) {
        this.appendCsvProperty(this.pluginDynaTagDepsCache, housing.getName(), uri);
    }

    public void removePluginDynaTagDep(JellyScriptHousing housing, String uri) {
        String prop = (String)((Hashtable)this.pluginDynaTagDepsCache).get(housing.getName());
        int tl = uri.length();
        if (prop.indexOf(",") < 0) {
            ((Hashtable)this.pluginDynaTagDepsCache).remove(housing.getName());
        } else {
            int i = prop.indexOf(uri + ",");
            prop = i == 0 ? prop.substring(tl + 1) : (i > 0 ? prop.substring(0, i) + prop.substring(i + tl + 1) : prop.substring(0, prop.length() - tl - 1));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caching Taglib Dependency --> " + prop));
            }
            ((Hashtable)this.pluginDynaTagDepsCache).put(housing.getName(), prop);
        }
    }

    public void addPostGoal(String name, JellyScriptHousing housing) {
        this.appendCsvProperty(this.callbackCache, name + ".post", housing.getName());
    }

    public void addPreGoal(String name, JellyScriptHousing housing) {
        this.appendCsvProperty(this.callbackCache, name + ".pre", housing.getName());
    }

    public void addGoal(String name, String prereqs, String description, JellyScriptHousing housing) {
        String goalProperty = description + ">";
        if (prereqs != null) {
            goalProperty = goalProperty + StringUtils.deleteWhitespace((String)prereqs);
        }
        this.goalCache.setProperty(name, goalProperty);
        this.pluginCache.setProperty(name, housing.getName());
    }

    public void addDynaTagLib(String tagLibUri, JellyScriptHousing housing) {
        this.dynaTagLibCache.setProperty(tagLibUri, housing.getName());
    }

    void invalidateCache(String pluginName) {
        Iterator i = ((Hashtable)this.goalCache).keySet().iterator();
        while (i.hasNext()) {
            String eachGoal = (String)i.next();
            if (!this.pluginCache.getProperty(eachGoal).equals(pluginName)) continue;
            i.remove();
            ((Hashtable)this.pluginCache).remove(eachGoal);
            ((Hashtable)this.callbackCache).remove(eachGoal + ".pre");
            ((Hashtable)this.callbackCache).remove(eachGoal + ".post");
        }
    }

    void mapPlugins(GoalToJellyScriptHousingMapper mapper, PluginManager manager) throws Exception {
        Map pluginHousings = manager.getPluginHousings();
        Iterator i = ((Hashtable)this.pluginDynaTagDepsCache).keySet().iterator();
        while (i.hasNext()) {
            String pluginName = (String)i.next();
            JellyScriptHousing housing = (JellyScriptHousing)pluginHousings.get(pluginName);
            if (housing == null && (housing = manager.loadPlugin(pluginName)) == null) {
                sessionLog.warn((Object)("plugin " + pluginName + " is cached as a dynatag dep, but no longer present."));
                continue;
            }
            String csv = this.pluginDynaTagDepsCache.getProperty(pluginName);
            StringTokenizer tok = new StringTokenizer(csv, ",");
            while (tok.hasMoreTokens()) {
                String uri = tok.nextToken();
                mapper.addPluginDynaTagDep(housing, uri);
            }
        }
        Iterator i2 = ((Hashtable)this.pluginCache).keySet().iterator();
        while (i2.hasNext()) {
            String goalName = (String)i2.next();
            String pluginName = this.pluginCache.getProperty(goalName);
            JellyScriptHousing housing = (JellyScriptHousing)pluginHousings.get(pluginName);
            if (housing == null && (housing = manager.loadPlugin(pluginName)) == null) {
                sessionLog.warn((Object)("plugin " + pluginName + " is cached, but no longer present."));
                continue;
            }
            String goal = this.goalCache.getProperty(goalName);
            int index = goal.indexOf(">");
            String description = null;
            if (index > 0) {
                description = goal.substring(0, index);
            }
            String prereqs = goal.substring(index + 1);
            mapper.addGoal(goalName, prereqs, description, housing);
        }
        Iterator i3 = ((Hashtable)this.callbackCache).keySet().iterator();
        while (i3.hasNext()) {
            String callbackName = (String)i3.next();
            boolean isPreGoal = callbackName.endsWith(".pre");
            String goalName = isPreGoal ? callbackName.substring(0, callbackName.length() - 4) : callbackName.substring(0, callbackName.length() - 5);
            String pluginNames = this.callbackCache.getProperty(callbackName);
            StringTokenizer tok = new StringTokenizer(pluginNames, ",");
            while (tok.hasMoreTokens()) {
                String pluginName = tok.nextToken();
                JellyScriptHousing housing = (JellyScriptHousing)pluginHousings.get(pluginName);
                if (housing == null && (housing = manager.loadPlugin(pluginName)) == null) {
                    sessionLog.warn((Object)("plugin " + pluginName + " is cached for callbacks, but no longer present."));
                    continue;
                }
                if (isPreGoal) {
                    mapper.addPreGoal(goalName, housing);
                    continue;
                }
                mapper.addPostGoal(goalName, housing);
            }
        }
        Iterator i4 = ((Hashtable)this.dynaTagLibCache).keySet().iterator();
        while (i4.hasNext()) {
            String uri = (String)i4.next();
            String pluginName = this.dynaTagLibCache.getProperty(uri);
            JellyScriptHousing housing = (JellyScriptHousing)pluginHousings.get(pluginName);
            if (housing == null && (housing = manager.loadPlugin(pluginName)) == null) {
                sessionLog.warn((Object)("plugin " + pluginName + " is cached for a dynatag library, but no longer present."));
                continue;
            }
            mapper.addDynaTagLib(uri, housing);
        }
    }

    public void setDefaultGoalName(String defaultGoalName) {
    }

    Properties getPluginCache() {
        return this.pluginCache;
    }

    public Properties getGoalCache() {
        return this.goalCache;
    }

    Properties getCallbackCache() {
        return this.callbackCache;
    }

    Properties getDynaTagLibCache() {
        return this.dynaTagLibCache;
    }

    Properties getPluginDynaTagDepsCache() {
        return this.pluginDynaTagDepsCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

