/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import com.werken.forehead.ForeheadClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.jelly.Script;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.apache.maven.plugin.PluginScriptParser;
import org.apache.maven.project.Project;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JellyScriptHousing {
    private Project project;
    private Script script;
    private File source;
    private ForeheadClassLoader pluginClassLoader;
    private final String name;
    private final File pluginDirectory;
    private final MavenJellyContext parentContext;

    public JellyScriptHousing() {
        this.name = null;
        this.pluginDirectory = null;
        this.parentContext = null;
    }

    public JellyScriptHousing(File pluginDir, MavenJellyContext parentContext) {
        this.pluginDirectory = pluginDir;
        this.name = pluginDir.getName();
        this.source = new File(pluginDir, "plugin.jelly");
        this.parentContext = parentContext;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public Project getProject() throws Exception {
        if (this.project == null) {
            this.project = MavenUtils.getProject(new File(this.pluginDirectory, "project.xml"), this.parentContext, false);
        }
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    Script getScript() {
        return this.script;
    }

    public String toString() {
        return "\n source = " + this.getSource() + "\n project = " + this.project + "\n script = " + this.script;
    }

    public String getName() {
        return this.name;
    }

    void parse(PluginDefinitionHandler handler, InputStream inStream) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        InputSource is = new InputSource(inStream);
        parser.parse(is, (DefaultHandler)new PluginScriptParser(handler, this));
    }

    void parse(PluginDefinitionHandler handler) throws IOException, ParserConfigurationException, SAXException {
        this.parse(handler, new FileInputStream(this.source));
    }

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }
}

