/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import com.werken.werkz.CyclicGoalChainException;
import com.werken.werkz.Goal;
import com.werken.werkz.NoSuchGoalException;
import com.werken.werkz.WerkzProject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.apache.maven.util.InsertionOrderedSet;
import org.apache.plexus.util.StringUtils;

public class GoalToJellyScriptHousingMapper
implements PluginDefinitionHandler {
    private HashMap dynaTagPluginMap = new HashMap();
    private HashMap pluginDynaTagDepsMap = new HashMap();
    private HashMap goalPluginMap = new HashMap();
    private HashMap preGoalDecoratorsMap = new HashMap();
    private HashMap postGoalDecoratorsMap = new HashMap();
    private final WerkzProject goalProject = new WerkzProject();
    private String defaultGoalName;
    private final HashSet resolvedPlugins = new HashSet();
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$plugin$GoalToJellyScriptHousingMapper == null ? (class$org$apache$maven$plugin$GoalToJellyScriptHousingMapper = GoalToJellyScriptHousingMapper.class$("org.apache.maven.plugin.GoalToJellyScriptHousingMapper")) : class$org$apache$maven$plugin$GoalToJellyScriptHousingMapper));
    static /* synthetic */ Class class$org$apache$maven$plugin$GoalToJellyScriptHousingMapper;

    void merge(GoalToJellyScriptHousingMapper mapper) throws CyclicGoalChainException {
        GoalToJellyScriptHousingMapper.mergeMap(this.dynaTagPluginMap, mapper.dynaTagPluginMap);
        GoalToJellyScriptHousingMapper.mergeMap(this.pluginDynaTagDepsMap, mapper.pluginDynaTagDepsMap);
        GoalToJellyScriptHousingMapper.mergeMap(this.goalPluginMap, mapper.goalPluginMap);
        Iterator i = mapper.preGoalDecoratorsMap.keySet().iterator();
        while (i.hasNext()) {
            String goalName = (String)i.next();
            Set s = (Set)mapper.preGoalDecoratorsMap.get(goalName);
            Set sExist = (Set)this.preGoalDecoratorsMap.get(goalName);
            if (sExist == null) {
                this.preGoalDecoratorsMap.put(goalName, s);
                continue;
            }
            sExist.addAll(s);
        }
        Iterator i2 = mapper.postGoalDecoratorsMap.keySet().iterator();
        while (i2.hasNext()) {
            String goalName = (String)i2.next();
            Set s = (Set)mapper.postGoalDecoratorsMap.get(goalName);
            Set sExist = (Set)this.postGoalDecoratorsMap.get(goalName);
            if (sExist == null) {
                this.postGoalDecoratorsMap.put(goalName, s);
                continue;
            }
            sExist.addAll(s);
        }
        if (this.defaultGoalName == null) {
            this.defaultGoalName = mapper.defaultGoalName;
        }
        Iterator i3 = mapper.goalProject.getGoals().iterator();
        while (i3.hasNext()) {
            Goal goal = (Goal)i3.next();
            Goal existingGoal = this.goalProject.getGoal(goal.getName());
            if (existingGoal == null) {
                this.goalProject.addGoal(goal);
                continue;
            }
            Iterator j = goal.getPrecursors().iterator();
            while (j.hasNext()) {
                existingGoal.addPrecursor((Goal)j.next());
            }
            Iterator j2 = goal.getPostcursors().iterator();
            while (j2.hasNext()) {
                existingGoal.addPostcursor((Goal)j2.next());
            }
        }
        this.resolvedPlugins.addAll(mapper.resolvedPlugins);
    }

    private static void mergeMap(Map target, Map source) {
        HashMap map = new HashMap(target);
        target.putAll(source);
        target.putAll(map);
    }

    public String getDefaultGoalName() {
        return this.defaultGoalName;
    }

    public void setDefaultGoalName(String defaultGoalName) {
        if (this.defaultGoalName == null) {
            this.defaultGoalName = defaultGoalName;
        }
    }

    public JellyScriptHousing getPluginHousing(String goal) {
        return (JellyScriptHousing)this.goalPluginMap.get(goal);
    }

    private HashSet getPluginDynaTagDeps(Object pluginHousing) {
        HashSet pluginDynaTagDeps = (HashSet)this.pluginDynaTagDepsMap.get(pluginHousing);
        if (pluginDynaTagDeps == null) {
            pluginDynaTagDeps = new HashSet();
            this.pluginDynaTagDepsMap.put(pluginHousing, pluginDynaTagDeps);
        }
        return pluginDynaTagDeps;
    }

    HashSet getPostGoalDecorators(String goalName) {
        HashSet decorators = (HashSet)this.postGoalDecoratorsMap.get(goalName);
        if (decorators == null) {
            decorators = new HashSet();
            this.postGoalDecoratorsMap.put(goalName, decorators);
        }
        return decorators;
    }

    HashSet getPreGoalDecorators(String goalName) {
        HashSet decorators = (HashSet)this.preGoalDecoratorsMap.get(goalName);
        if (decorators == null) {
            decorators = new HashSet();
            this.preGoalDecoratorsMap.put(goalName, decorators);
        }
        return decorators;
    }

    Set resolveJellyScriptHousings(String goal) throws NoSuchGoalException {
        InsertionOrderedSet pluginSet = new InsertionOrderedSet();
        Goal[] chain = this.getExecutionChain(goal, this.goalProject);
        int i = 0;
        while (i < chain.length) {
            Goal g = chain[i];
            Object plugin = this.goalPluginMap.get(g.getName());
            if (plugin == null) {
                throw new NoSuchGoalException(g.getName());
            }
            pluginSet.add(plugin);
            HashSet decorators = this.getPostGoalDecorators(g.getName());
            pluginSet.addAll(decorators);
            decorators = this.getPreGoalDecorators(g.getName());
            pluginSet.addAll(decorators);
            ++i;
        }
        InsertionOrderedSet newPluginSet = this.resolveDynaTagPlugins(pluginSet);
        newPluginSet.addAll((Collection)pluginSet);
        pluginSet = newPluginSet;
        pluginSet.removeAll(this.resolvedPlugins);
        this.resolvedPlugins.addAll(pluginSet);
        return pluginSet;
    }

    public Goal[] getExecutionChain(String name, WerkzProject project) throws NoSuchGoalException {
        Goal goal = project.getGoal(name);
        LinkedList<Goal> chain = new LinkedList<Goal>();
        LinkedList<Goal> stack = new LinkedList<Goal>();
        stack.addLast(goal);
        while (!stack.isEmpty()) {
            goal = (Goal)stack.removeFirst();
            if (goal == null || chain.contains(goal)) continue;
            chain.addFirst(goal);
            List precursors = goal.getPrecursors();
            Iterator i = precursors.iterator();
            while (i.hasNext()) {
                Goal eachPrecursor = (Goal)i.next();
                if (chain.contains(eachPrecursor)) continue;
                stack.addLast(eachPrecursor);
            }
        }
        return chain.toArray(Goal.EMPTY_ARRAY);
    }

    private InsertionOrderedSet resolveDynaTagPlugins(Set plugins) {
        InsertionOrderedSet resolvedDynaTagPlugins = new InsertionOrderedSet();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            JellyScriptHousing plugin = (JellyScriptHousing)i.next();
            HashSet dynaTagDeps = this.getPluginDynaTagDeps(plugin);
            Iterator j = dynaTagDeps.iterator();
            while (j.hasNext()) {
                LinkedList dynaTagUris = new LinkedList();
                HashSet<String> seen = new HashSet<String>();
                Object next = j.next();
                dynaTagUris.add(next);
                while (!dynaTagUris.isEmpty()) {
                    String dynaTagUri = (String)dynaTagUris.removeFirst();
                    if (seen.contains(dynaTagUri)) continue;
                    seen.add(dynaTagUri);
                    Object dynaTagPluginHome = this.dynaTagPluginMap.get(dynaTagUri);
                    if (dynaTagPluginHome == null) {
                        log.warn((Object)("Tag library requested that is not present: '" + dynaTagUri + "' in plugin: '" + plugin.getName() + "'"));
                        continue;
                    }
                    HashSet set = this.getPluginDynaTagDeps(dynaTagPluginHome);
                    dynaTagUris.addAll(set);
                    resolvedDynaTagPlugins.add(dynaTagPluginHome);
                }
            }
        }
        return resolvedDynaTagPlugins;
    }

    public void addPluginDynaTagDep(JellyScriptHousing housing, String uri) {
        this.getPluginDynaTagDeps(housing).add(uri);
    }

    public void removePluginDynaTagDep(JellyScriptHousing housing, String uri) {
        this.getPluginDynaTagDeps(housing).remove(uri);
    }

    public void addDynaTagLib(String tagLibUri, JellyScriptHousing jellyScriptHousing) {
        this.dynaTagPluginMap.put(tagLibUri, jellyScriptHousing);
    }

    public void addPostGoal(String name, JellyScriptHousing jellyScriptHousing) {
        this.getPostGoalDecorators(name).add(jellyScriptHousing);
    }

    public void addPreGoal(String name, JellyScriptHousing jellyScriptHousing) {
        this.getPreGoalDecorators(name).add(jellyScriptHousing);
    }

    public void addGoal(String name, String prereqs, String description, JellyScriptHousing jellyScriptHousing) {
        if (!this.goalPluginMap.containsKey(name)) {
            Goal goal = this.goalProject.getGoal(name, true);
            goal.setDescription(description);
            this.goalProject.addGoal(goal);
            this.goalPluginMap.put(name, jellyScriptHousing);
            if (prereqs != null) {
                String[] s = StringUtils.split((String)prereqs, (String)",");
                int i = 0;
                while (i < s.length) {
                    try {
                        Goal prereq = this.goalProject.getGoal(s[i].trim(), true);
                        goal.addPrecursor(prereq);
                    }
                    catch (CyclicGoalChainException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }

    Set getGoalNames() {
        return this.goalPluginMap.keySet();
    }

    String getGoalDescription(String goalName) {
        Goal goal = this.goalProject.getGoal(goalName);
        return goal != null ? goal.getDescription() : "";
    }

    void addResolvedPlugins(List projectHousings) {
        this.resolvedPlugins.addAll(projectHousings);
    }

    void clearResolvedPlugins() {
        this.resolvedPlugins.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

