/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.tags.maven.DependencyResolver;
import org.apache.maven.jelly.tags.maven.MavenTag;
import org.apache.maven.project.Project;

public class ReactorTag
extends MavenTag {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$jelly$tags$maven$ReactorTag == null ? (class$org$apache$maven$jelly$tags$maven$ReactorTag = ReactorTag.class$("org.apache.maven.jelly.tags.maven.ReactorTag")) : class$org$apache$maven$jelly$tags$maven$ReactorTag));
    private String glob;
    private String includes;
    private String excludes;
    private String banner;
    private File basedir;
    private boolean postProcessing = false;
    private Collection failedProjects = new ArrayList();
    private ArrayList reactorProjects = new ArrayList();
    static /* synthetic */ Class class$org$apache$maven$jelly$tags$maven$ReactorTag;

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setPostProcessing(boolean postProcessing) {
        this.postProcessing = postProcessing;
    }

    public boolean getPostProcessing() {
        return this.postProcessing;
    }

    public void setGlob(String glob) {
        log.warn((Object)"\nDEPRECATION WARNING: use the 'includes' attribute instead of the 'glob' attribute.\n");
        this.glob = glob;
    }

    public String getGlob() {
        return this.glob;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public String getBanner() {
        if (this.banner == null) {
            this.banner = "Processing";
        }
        return this.banner;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.getBasedir(), "basedir");
        if (this.getGlob() == null && this.getIncludes() == null) {
            throw new MissingAttributeException("glob|includes");
        }
        log.info((Object)"Starting the reactor...");
        List sortedProjects = null;
        try {
            sortedProjects = this.getSortedProjects();
        }
        catch (Exception e) {
            throw new JellyTagException("Error getting projects", (Throwable)e);
        }
        log.info((Object)"Our processing order:");
        Iterator i = sortedProjects.iterator();
        while (i.hasNext()) {
            Project p = (Project)i.next();
            log.info((Object)p.getName());
        }
        Runtime r = Runtime.getRuntime();
        Iterator i2 = sortedProjects.iterator();
        while (i2.hasNext()) {
            Project project;
            block11: {
                project = (Project)i2.next();
                this.beforeProject(project);
                try {
                    long mb = 0x100000L;
                    log.info((Object)"+----------------------------------------");
                    log.info((Object)("| " + this.getBanner() + " " + project.getName()));
                    log.info((Object)("| Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M"));
                    log.info((Object)"+----------------------------------------");
                    List goalList = null;
                    if (this.getGoals() != null) {
                        goalList = MavenUtils.getGoalListFromCsv(this.getGoals());
                    }
                    this.beforeLaunchGoals(project);
                    this.getMavenContext().getMavenSession().attainGoals(project, goalList);
                    this.afterLaunchGoals(project);
                }
                catch (Exception e) {
                    this.onException(project, e);
                    if (this.isIgnoreFailures()) break block11;
                    throw new JellyTagException("Reactor subproject failure occurred", (Throwable)e);
                }
            }
            this.afterProject(project);
            if (this.getPostProcessing()) {
                this.reactorProjects.add(project);
            }
            i2.remove();
        }
        this.getContext().setVariable("reactorProjects", (Object)this.reactorProjects);
        ArrayList c = (ArrayList)this.getContext().getVariable("failedProjects");
        if (c == null) {
            c = new ArrayList(this.failedProjects);
        } else {
            c.addAll(this.failedProjects);
        }
        this.getContext().setVariable("failedProjects", c);
    }

    private List getSortedProjects() throws Exception {
        String projectIncludes = this.getGlob() != null ? this.getGlob() : this.getIncludes();
        List projects = MavenUtils.getProjects(this.getBasedir(), projectIncludes, this.getExcludes(), this.getMavenContext().getMavenSession().getRootContext());
        DependencyResolver dr = new DependencyResolver();
        dr.setProjects(projects);
        return dr.getSortedDependencies(false);
    }

    public void beforeProject(Project project) {
    }

    public void beforeLaunchGoals(Project project) {
    }

    public void afterLaunchGoals(Project project) {
    }

    public void afterProject(Project project) {
    }

    public void onException(Project project, Exception e) {
        this.getMavenContext().setVariable("maven.build.failure", "true");
        this.failedProjects.add(project);
    }

    public void onDependencyResolutionException(Exception e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

