/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.maven.jelly.MavenJellyContext;
import org.xml.sax.XMLReader;

public class JellyUtils {
    public static void runScript(InputStream scriptInputStream, URL rootUrl, JellyContext context, XMLOutput output) throws Exception {
        URL oldRoot = context.getRootURL();
        URL oldCurrent = context.getCurrentURL();
        if (rootUrl != null) {
            context.setRootURL(rootUrl);
            context.setCurrentURL(rootUrl);
        }
        Script script = JellyUtils.compileScript(scriptInputStream, context);
        script.run(context, output);
        context.setRootURL(oldRoot);
        context.setCurrentURL(oldCurrent);
    }

    public static void runScript(File scriptFile, URL rootUrl, JellyContext context, XMLOutput output) throws Exception {
        if (!scriptFile.canRead() || scriptFile.length() < 1L) {
            return;
        }
        JellyUtils.runScript(new FileInputStream(scriptFile), rootUrl, context, output);
    }

    public static Script compileScript(File scriptFile, JellyContext context) throws Exception {
        return JellyUtils.compileScript(new FileInputStream(scriptFile), context);
    }

    public static Script compileScript(InputStream scriptInputStream, JellyContext context) throws Exception {
        return JellyUtils.compileScript(scriptInputStream, context, null);
    }

    public static Script compileScript(InputStream scriptInputStream, JellyContext context, String encoding) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        XMLParser parser = new XMLParser(reader);
        parser.setContext(context);
        parser.setClassLoader(context.getClassLoader());
        Script script = null;
        script = encoding != null ? parser.parse((Reader)new InputStreamReader(scriptInputStream, encoding)) : parser.parse(scriptInputStream);
        script = script.compile();
        return script;
    }

    public static Expression decomposeExpression(String text, ExpressionFactory factory, JellyContext context) {
        Expression expression = null;
        try {
            expression = CompositeExpression.parse((String)text, (ExpressionFactory)factory);
            String expressionText = expression.evaluateAsString(context);
            if (CompositeExpression.parse((String)expressionText, (ExpressionFactory)factory) instanceof CompositeExpression) {
                expression = JellyUtils.decomposeExpression(expressionText, factory, context);
            }
        }
        catch (Exception e) {}
        return expression;
    }

    public static void compareContexts(MavenJellyContext ctx1, MavenJellyContext ctx2) {
        System.out.println("======== compare contexts ========");
        Iterator i = ctx1.getVariableNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (ctx2.getVariable(name) == null) {
                System.out.println(name + " not in ctx2");
                continue;
            }
            if (ctx2.getVariable(name).equals(ctx1.getVariable(name))) continue;
            System.out.println(name + " doesn't match: '" + ctx1.getVariable(name) + "' vs '" + ctx2.getVariable(name) + "'");
        }
        System.out.println("======== comparison  done ========");
    }
}

