/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.Project;

public class MavenSession
extends AbstractMavenComponent {
    public static final String BUILD_START_GOAL = "build:start";
    public static final String BUILD_END_GOAL = "build:end";
    public static final String DRIVER_SCRIPT_NAME = "driver.jelly";
    public static final String APP_VERSION = "1.0-rc2";
    private MavenJellyContext rootContext;
    private static File rootDescriptorFile;
    private Project rootProject;
    private PluginManager pluginManager = new PluginManager(this);

    public void setRootContext(MavenJellyContext context) {
        this.rootContext = context;
    }

    public MavenJellyContext getRootContext() {
        return this.rootContext;
    }

    public static void setRootDescriptorFile(File descriptorFile) {
        rootDescriptorFile = descriptorFile;
    }

    public static File getRootDescriptorFile() {
        return rootDescriptorFile;
    }

    public void setRootProject(Project project) {
        this.rootProject = project;
    }

    public Project getRootProject() {
        return this.rootProject;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void initialize() throws Exception {
        this.getRootContext().setMavenSession(this);
        this.initializePluginManager();
        this.initializeRootProject();
    }

    public Set getAllGoalNames() {
        return this.getPluginManager().getGoalNames();
    }

    public String getGoalDescription(String goalName) {
        return this.getPluginManager().getGoalDescription(goalName);
    }

    private void initializePluginManager() throws Exception {
        this.getPluginManager().initialize();
    }

    private void initializeRootProject() throws Exception {
        File descriptorFile = MavenSession.getRootDescriptorFile();
        if (descriptorFile.exists()) {
            if (descriptorFile.length() == 0L) {
                throw new Exception(MavenUtils.getMessage("empty.descriptor.error", descriptorFile.getName()));
            }
            this.setRootProject(MavenUtils.getProject(descriptorFile, this.getRootContext()));
        } else {
            Project globalProject = new Project();
            globalProject.setId("Global Project");
            globalProject.setFile(descriptorFile);
            this.getRootContext().setProject(globalProject);
            globalProject.setContext(this.getRootContext());
            this.setRootProject(globalProject);
        }
    }

    public void attainGoals(Project project, List goals) throws Exception {
        this.pluginManager.attainGoals(project, goals);
    }
}

