/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.AbstractDeployer;
import org.apache.maven.deploy.exceptions.AuthenticationException;
import org.apache.maven.deploy.exceptions.TransferFailedException;

public class FtpDeployer
extends AbstractDeployer {
    public static final String PROTOCOL = "ftp://";
    private FTPClient ftp = null;

    public void init(RepositoryInfo repoInfo) throws AuthenticationException {
        String username = repoInfo.getUserName();
        String password = repoInfo.getPassword();
        String host = repoInfo.getHost();
        this.ftp = new FTPClient();
        if (repoInfo.isDebugOn()) {
            this.ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        }
        try {
            if (repoInfo.getPort() != -1) {
                this.ftp.connect(host, repoInfo.getPort());
            } else {
                this.ftp.connect(host);
            }
            System.out.println("Connected to " + host + ".");
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftp.disconnect();
                System.err.println();
                throw new AuthenticationException("FTP server refused connection.");
            }
        }
        catch (IOException e) {
            if (this.ftp.isConnected()) {
                try {
                    this.ftp.disconnect();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw new AuthenticationException("Could not connect to server.");
        }
        try {
            if (!this.ftp.login(username.trim(), password.trim())) {
                throw new AuthenticationException("Cannot login to remote system");
            }
            System.out.println("Remote system is " + this.ftp.getSystemName());
            this.ftp.setFileType(2);
            this.ftp.enterLocalPassiveMode();
            this.ftp.changeWorkingDirectory(repoInfo.getBasedir());
        }
        catch (IOException e) {
            throw new AuthenticationException("Cannot login to remote system");
        }
    }

    public void release() {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void deploy(DeployRequest request) throws TransferFailedException {
        try {
            int i;
            String[] dirs = StringUtils.split((String)request.dirname(), (String)"/");
            for (i = 0; i < dirs.length; ++i) {
                this.ftp.makeDirectory(dirs[i]);
                this.ftp.changeWorkingDirectory(dirs[i]);
            }
            this.ftp.storeFile(request.filename(), (InputStream)new FileInputStream(request.getSrcFile()));
            for (i = 0; i < dirs.length; ++i) {
                this.ftp.changeWorkingDirectory("..");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransferFailedException(e.getMessage());
        }
    }

    public class PrintCommandListener
    implements ProtocolCommandListener {
        private PrintWriter writer;

        public PrintCommandListener(PrintWriter writer) {
            this.writer = writer;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            this.writer.print(event.getMessage());
            this.writer.flush();
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.writer.print(event.getMessage());
            this.writer.flush();
        }
    }
}

