/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private String name;
    private String description;
    private Hashtable properties = new Hashtable();
    private Hashtable userProperties = new Hashtable();
    private Hashtable inheritedProperties = new Hashtable();
    private Hashtable references = new Hashtable();
    private String defaultTarget;
    private Hashtable dataClassDefinitions = new Hashtable();
    private Hashtable taskClassDefinitions = new Hashtable();
    private Hashtable createdTasks = new Hashtable();
    private Hashtable targets = new Hashtable();
    private FilterSet globalFilterSet = new FilterSet();
    private FilterSetCollection globalFilters = new FilterSetCollection(this.globalFilterSet);
    private File baseDir;
    private Vector listeners = new Vector();
    private ClassLoader coreLoader = null;
    private Hashtable threadTasks = new Hashtable();
    private InputHandler inputHandler = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private boolean loggingMessage = false;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setInputHandler(InputHandler handler) {
        this.inputHandler = handler;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public Project() {
        this.inputHandler = new DefaultInputHandler();
    }

    public void init() throws BuildException {
        this.setJavaVersionProperty();
        String defs = "/org/apache/tools/ant/taskdefs/defaults.properties";
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(defs);
            if (in == null) {
                throw new BuildException("Can't load default task list");
            }
            props.load(in);
            in.close();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                try {
                    Class<?> taskClass = Class.forName(value);
                    this.addTaskDefinition(key, taskClass);
                }
                catch (NoClassDefFoundError ncdfe) {
                    this.log("Could not load a dependent class (" + ncdfe.getMessage() + ") for task " + key, 4);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log("Could not load class (" + value + ") for task " + key, 4);
                }
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Can't load default task list");
        }
        String dataDefs = "/org/apache/tools/ant/types/defaults.properties";
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream(dataDefs);
            if (in == null) {
                throw new BuildException("Can't load default datatype list");
            }
            props.load(in);
            in.close();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                try {
                    Class<?> dataClass = Class.forName(value);
                    this.addDataTypeDefinition(key, dataClass);
                }
                catch (NoClassDefFoundError ncdfe) {
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Can't load default datatype list");
        }
        this.setSystemProperties();
    }

    public void setCoreLoader(ClassLoader coreLoader) {
        this.coreLoader = coreLoader;
    }

    public ClassLoader getCoreLoader() {
        return this.coreLoader;
    }

    public void addBuildListener(BuildListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeBuildListener(BuildListener listener) {
        this.listeners.removeElement(listener);
    }

    public Vector getBuildListeners() {
        return (Vector)this.listeners.clone();
    }

    public void log(String message) {
        this.log(message, 2);
    }

    public void log(String message, int msgLevel) {
        this.fireMessageLogged(this, message, msgLevel);
    }

    public void log(Task task, String message, int msgLevel) {
        this.fireMessageLogged(task, message, msgLevel);
    }

    public void log(Target target, String message, int msgLevel) {
        this.fireMessageLogged(target, message, msgLevel);
    }

    public FilterSet getGlobalFilterSet() {
        return this.globalFilterSet;
    }

    public synchronized void setProperty(String name, String value) {
        if (null != this.userProperties.get(name)) {
            this.log("Override ignored for user property " + name, 3);
            return;
        }
        if (null != this.properties.get(name)) {
            this.log("Overriding previous definition of property " + name, 3);
        }
        this.log("Setting project property: " + name + " -> " + value, 4);
        this.properties.put(name, value);
    }

    public synchronized void setNewProperty(String name, String value) {
        if (null != this.properties.get(name)) {
            this.log("Override ignored for property " + name, 3);
            return;
        }
        this.log("Setting project property: " + name + " -> " + value, 4);
        this.properties.put(name, value);
    }

    public synchronized void setUserProperty(String name, String value) {
        this.log("Setting ro project property: " + name + " -> " + value, 4);
        this.userProperties.put(name, value);
        this.properties.put(name, value);
    }

    public synchronized void setInheritedProperty(String name, String value) {
        this.inheritedProperties.put(name, value);
        this.setUserProperty(name, value);
    }

    private void setPropertyInternal(String name, String value) {
        if (null != this.userProperties.get(name)) {
            return;
        }
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String property = (String)this.properties.get(name);
        return property;
    }

    public String replaceProperties(String value) throws BuildException {
        return ProjectHelper.replaceProperties(this, value, this.properties);
    }

    public String getUserProperty(String name) {
        if (name == null) {
            return null;
        }
        String property = (String)this.userProperties.get(name);
        return property;
    }

    public Hashtable getProperties() {
        Hashtable propertiesCopy = new Hashtable();
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object value = this.properties.get(name);
            propertiesCopy.put(name, value);
        }
        return propertiesCopy;
    }

    public Hashtable getUserProperties() {
        Hashtable propertiesCopy = new Hashtable();
        Enumeration e = this.userProperties.keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object value = this.properties.get(name);
            propertiesCopy.put(name, value);
        }
        return propertiesCopy;
    }

    public void copyUserProperties(Project other) {
        Enumeration e = this.userProperties.keys();
        while (e.hasMoreElements()) {
            Object arg = e.nextElement();
            if (this.inheritedProperties.containsKey(arg)) continue;
            Object value = this.userProperties.get(arg);
            other.setUserProperty(arg.toString(), value.toString());
        }
    }

    public void copyInheritedProperties(Project other) {
        Enumeration e = this.inheritedProperties.keys();
        while (e.hasMoreElements()) {
            String arg = e.nextElement().toString();
            if (other.getUserProperty(arg) != null) continue;
            Object value = this.inheritedProperties.get(arg);
            other.setInheritedProperty(arg, value.toString());
        }
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefault(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public void setName(String name) {
        this.setUserProperty("ant.project.name", name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addFilter(String token, String value) {
        if (token == null) {
            return;
        }
        this.globalFilterSet.addFilter(new FilterSet.Filter(token, value));
    }

    public Hashtable getFilters() {
        return this.globalFilterSet.getFilterHash();
    }

    public void setBasedir(String baseD) throws BuildException {
        this.setBaseDir(new File(baseD));
    }

    public void setBaseDir(File baseDir) throws BuildException {
        if (!(baseDir = this.fileUtils.normalize(baseDir.getAbsolutePath())).exists()) {
            throw new BuildException("Basedir " + baseDir.getAbsolutePath() + " does not exist");
        }
        if (!baseDir.isDirectory()) {
            throw new BuildException("Basedir " + baseDir.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = baseDir;
        this.setPropertyInternal("basedir", this.baseDir.getPath());
        String msg = "Project base dir set to: " + this.baseDir;
        this.log(msg, 3);
    }

    public File getBaseDir() {
        block2: {
            if (this.baseDir != null) break block2;
            try {
                this.setBasedir(".");
            }
            catch (BuildException ex) {
                ex.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public static String getJavaVersion() {
        return JavaEnvUtils.getJavaVersion();
    }

    public void setJavaVersionProperty() throws BuildException {
        String javaVersion = JavaEnvUtils.getJavaVersion();
        this.setPropertyInternal("ant.java.version", javaVersion);
        if (JavaEnvUtils.isJavaVersion(JAVA_1_0)) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java version: " + javaVersion + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void setSystemProperties() {
        Properties systemP = System.getProperties();
        Enumeration e = ((Hashtable)systemP).keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            String value = ((Hashtable)systemP).get(name).toString();
            this.setPropertyInternal(name.toString(), value);
        }
    }

    public void addTaskDefinition(String taskName, Class taskClass) throws BuildException {
        Class old = (Class)this.taskClassDefinitions.get(taskName);
        if (null != old) {
            if (old.equals(taskClass)) {
                this.log("Ignoring override for task " + taskName + ", it is already defined by the same class.", 3);
                return;
            }
            int logLevel = 1;
            if (old.getName().equals(taskClass.getName())) {
                ClassLoader oldLoader = old.getClassLoader();
                ClassLoader newLoader = taskClass.getClassLoader();
                if (oldLoader != null && newLoader != null && oldLoader instanceof AntClassLoader && newLoader instanceof AntClassLoader && ((AntClassLoader)oldLoader).getClasspath().equals(((AntClassLoader)newLoader).getClasspath())) {
                    logLevel = 3;
                }
            }
            this.log("Trying to override old definition of task " + taskName, logLevel);
            this.invalidateCreatedTasks(taskName);
        }
        String msg = " +User task: " + taskName + "     " + taskClass.getName();
        this.log(msg, 4);
        this.checkTaskClass(taskClass);
        this.taskClassDefinitions.put(taskName, taskClass);
    }

    public void checkTaskClass(Class taskClass) throws BuildException {
        if (!Modifier.isPublic(taskClass.getModifiers())) {
            String message = taskClass + " is not public";
            this.log(message, 0);
            throw new BuildException(message);
        }
        if (Modifier.isAbstract(taskClass.getModifiers())) {
            String message = taskClass + " is abstract";
            this.log(message, 0);
            throw new BuildException(message);
        }
        try {
            taskClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            String message = "No public no-arg constructor in " + taskClass;
            this.log(message, 0);
            throw new BuildException(message);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = Project.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(taskClass)) {
            TaskAdapter.checkTaskClass(taskClass, this);
        }
    }

    public Hashtable getTaskDefinitions() {
        return this.taskClassDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataTypeDefinition(String typeName, Class typeClass) {
        Hashtable hashtable = this.dataClassDefinitions;
        synchronized (hashtable) {
            Class old = (Class)this.dataClassDefinitions.get(typeName);
            if (null != old) {
                if (old.equals(typeClass)) {
                    this.log("Ignoring override for datatype " + typeName + ", it is already defined by the same class.", 3);
                    return;
                }
                this.log("Trying to override old definition of datatype " + typeName, 1);
            }
            this.dataClassDefinitions.put(typeName, typeClass);
        }
        String msg = " +User datatype: " + typeName + "     " + typeClass.getName();
        this.log(msg, 4);
    }

    public Hashtable getDataTypeDefinitions() {
        return this.dataClassDefinitions;
    }

    public void addTarget(Target target) throws BuildException {
        String name = target.getName();
        if (this.targets.get(name) != null) {
            throw new BuildException("Duplicate target: `" + name + "'");
        }
        this.addOrReplaceTarget(name, target);
    }

    public void addTarget(String targetName, Target target) throws BuildException {
        if (this.targets.get(targetName) != null) {
            throw new BuildException("Duplicate target: `" + targetName + "'");
        }
        this.addOrReplaceTarget(targetName, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addOrReplaceTarget(String targetName, Target target) {
        String msg = " +Target: " + targetName;
        this.log(msg, 4);
        target.setProject(this);
        this.targets.put(targetName, target);
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Task createTask(String taskType) throws BuildException {
        Class c = (Class)this.taskClassDefinitions.get(taskType);
        if (c == null) {
            return null;
        }
        try {
            Object o = c.newInstance();
            Task task = null;
            if (o instanceof Task) {
                task = (Task)o;
            } else {
                TaskAdapter taskA = new TaskAdapter();
                taskA.setProxy(o);
                task = taskA;
            }
            task.setProject(this);
            task.setTaskType(taskType);
            task.setTaskName(taskType);
            String msg = "   +Task: " + taskType;
            this.log(msg, 4);
            this.addCreatedTask(taskType, task);
            return task;
        }
        catch (Throwable t) {
            String msg = "Could not create task of type: " + taskType + " due to " + t;
            throw new BuildException(msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCreatedTask(String type, Task task) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector<Task> v = (Vector<Task>)this.createdTasks.get(type);
            if (v == null) {
                v = new Vector<Task>();
                this.createdTasks.put(type, v);
            }
            v.addElement(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCreatedTasks(String type) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector v = (Vector)this.createdTasks.get(type);
            if (v != null) {
                Enumeration enumeration = v.elements();
                while (enumeration.hasMoreElements()) {
                    Task t = (Task)enumeration.nextElement();
                    t.markInvalid();
                }
                v.removeAllElements();
                this.createdTasks.remove(type);
            }
        }
    }

    public Object createDataType(String typeName) throws BuildException {
        Class c = (Class)this.dataClassDefinitions.get(typeName);
        if (c == null) {
            return null;
        }
        try {
            Constructor ctor = null;
            boolean noArg = false;
            try {
                ctor = c.getConstructor(new Class[0]);
                noArg = true;
            }
            catch (NoSuchMethodException nse) {
                ctor = c.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Project.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
                noArg = false;
            }
            Object o = null;
            o = noArg ? ctor.newInstance(new Object[0]) : ctor.newInstance(this);
            if (o instanceof ProjectComponent) {
                ((ProjectComponent)o).setProject(this);
            }
            String msg = "   +DataType: " + typeName;
            this.log(msg, 4);
            return o;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String msg = "Could not create datatype of type: " + typeName + " due to " + t;
            throw new BuildException(msg, t);
        }
        catch (Throwable t) {
            String msg = "Could not create datatype of type: " + typeName + " due to " + t;
            throw new BuildException(msg, t);
        }
    }

    public void executeTargets(Vector targetNames) throws BuildException {
        Object error = null;
        int i = 0;
        while (i < targetNames.size()) {
            this.executeTarget((String)targetNames.elementAt(i));
            ++i;
        }
    }

    public void demuxOutput(String line, boolean isError) {
        Task task = (Task)this.threadTasks.get(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, line, isError ? 0 : 2);
        } else if (isError) {
            task.handleErrorOutput(line);
        } else {
            task.handleOutput(line);
        }
    }

    public void demuxFlush(String line, boolean isError) {
        Task task = (Task)this.threadTasks.get(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, line, isError ? 0 : 2);
        } else if (isError) {
            task.handleErrorFlush(line);
        } else {
            task.handleFlush(line);
        }
    }

    public void executeTarget(String targetName) throws BuildException {
        Target curtarget;
        if (targetName == null) {
            String msg = "No target specified";
            throw new BuildException(msg);
        }
        Vector sortedTargets = this.topoSort(targetName, this.targets);
        int curidx = 0;
        do {
            curtarget = (Target)sortedTargets.elementAt(curidx++);
            curtarget.performTasks();
        } while (!curtarget.getName().equals(targetName));
    }

    public File resolveFile(String fileName, File rootDir) {
        return this.fileUtils.resolveFile(rootDir, fileName);
    }

    public File resolveFile(String fileName) {
        return this.fileUtils.resolveFile(this.baseDir, fileName);
    }

    public static String translatePath(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return "";
        }
        StringBuffer path = new StringBuffer(toProcess.length() + 50);
        PathTokenizer tokenizer = new PathTokenizer(toProcess);
        while (tokenizer.hasMoreTokens()) {
            String pathComponent = tokenizer.nextToken();
            pathComponent = pathComponent.replace('/', File.separatorChar);
            pathComponent = pathComponent.replace('\\', File.separatorChar);
            if (path.length() != 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(pathComponent);
        }
        return path.toString();
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite, preserveLastModified);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.fileUtils.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite, preserveLastModified);
    }

    public void setFileLastModified(File file, long time) throws BuildException {
        if (JavaEnvUtils.isJavaVersion(JAVA_1_1)) {
            this.log("Cannot change the modification time of " + file + " in JDK 1.1", 1);
            return;
        }
        this.fileUtils.setFileLastModified(file, time);
        this.log("Setting modification time for " + file, 3);
    }

    public static boolean toBoolean(String s) {
        return s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
    }

    public final Vector topoSort(String root, Hashtable targets) throws BuildException {
        Vector ret = new Vector();
        Hashtable state = new Hashtable();
        Stack visiting = new Stack();
        this.tsort(root, targets, state, visiting, ret);
        this.log("Build sequence for target `" + root + "' is " + ret, 3);
        Enumeration en = targets.keys();
        while (en.hasMoreElements()) {
            String curTarget = (String)en.nextElement();
            String st = (String)state.get(curTarget);
            if (st == null) {
                this.tsort(curTarget, targets, state, visiting, ret);
                continue;
            }
            if (st != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + curTarget);
        }
        this.log("Complete build sequence is " + ret, 3);
        return ret;
    }

    private final void tsort(String root, Hashtable targets, Hashtable state, Stack visiting, Vector ret) throws BuildException {
        state.put(root, VISITING);
        visiting.push(root);
        Target target = (Target)targets.get(root);
        if (target == null) {
            StringBuffer sb = new StringBuffer("Target `");
            sb.append(root);
            sb.append("' does not exist in this project. ");
            visiting.pop();
            if (!visiting.empty()) {
                String parent = (String)visiting.peek();
                sb.append("It is used from target `");
                sb.append(parent);
                sb.append("'.");
            }
            throw new BuildException(new String(sb));
        }
        Enumeration en = target.getDependencies();
        while (en.hasMoreElements()) {
            String cur = (String)en.nextElement();
            String m = (String)state.get(cur);
            if (m == null) {
                this.tsort(cur, targets, state, visiting, ret);
                continue;
            }
            if (m != VISITING) continue;
            throw Project.makeCircularException(cur, visiting);
        }
        String p = (String)visiting.pop();
        if (root != p) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + root + " but got " + p);
        }
        state.put(root, VISITED);
        ret.addElement(target);
    }

    private static BuildException makeCircularException(String end, Stack stk) {
        String c;
        StringBuffer sb = new StringBuffer("Circular dependency: ");
        sb.append(end);
        do {
            c = (String)stk.pop();
            sb.append(" <- ");
            sb.append(c);
        } while (!c.equals(end));
        return new BuildException(new String(sb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(String name, Object value) {
        Hashtable hashtable = this.references;
        synchronized (hashtable) {
            Object old = this.references.get(name);
            if (old == value) {
                return;
            }
            if (old != null && !(old instanceof UnknownElement)) {
                this.log("Overriding previous definition of reference to " + name, 1);
            }
            String valueAsString = "";
            try {
                valueAsString = value.toString();
            }
            catch (Throwable t) {
                this.log("Caught exception (" + t.getClass().getName() + ")" + " while expanding " + name + ": " + t.getMessage(), 1);
            }
            this.log("Adding reference: " + name + " -> " + valueAsString, 4);
            this.references.put(name, value);
        }
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Object getReference(String key) {
        return this.references.get(key);
    }

    public String getElementName(Object element) {
        Hashtable elements = this.taskClassDefinitions;
        Class<?> elementClass = element.getClass();
        String typeName = "task";
        if (!elements.contains(elementClass)) {
            elements = this.dataClassDefinitions;
            typeName = "data type";
            if (!elements.contains(elementClass)) {
                elements = null;
            }
        }
        if (elements != null) {
            Enumeration e = elements.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Class clazz = (Class)elements.get(name);
                if (!elementClass.equals(clazz)) continue;
                return "The <" + name + "> " + typeName;
            }
        }
        return "Class " + elementClass.getName();
    }

    public void fireBuildStarted() {
        BuildEvent event = new BuildEvent(this);
        Vector listeners = this.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.buildStarted(event);
            ++i;
        }
    }

    public void fireBuildFinished(Throwable exception) {
        BuildEvent event = new BuildEvent(this);
        event.setException(exception);
        Vector listeners = this.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.buildFinished(event);
            ++i;
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent event = new BuildEvent(target);
        Vector listeners = this.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.targetStarted(event);
            ++i;
        }
    }

    protected void fireTargetFinished(Target target, Throwable exception) {
        BuildEvent event = new BuildEvent(target);
        event.setException(exception);
        Vector listeners = this.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.targetFinished(event);
            ++i;
        }
    }

    protected void fireTaskStarted(Task task) {
        this.registerThreadTask(Thread.currentThread(), task);
        BuildEvent event = new BuildEvent(task);
        Vector listeners = this.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.taskStarted(event);
            ++i;
        }
    }

    protected void fireTaskFinished(Task task, Throwable exception) {
        this.registerThreadTask(Thread.currentThread(), null);
        System.out.flush();
        System.err.flush();
        BuildEvent event = new BuildEvent(task);
        event.setException(exception);
        Vector listeners = this.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            listener.taskFinished(event);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageLoggedEvent(BuildEvent event, String message, int priority) {
        event.setMessage(message, priority);
        Vector listeners = this.getBuildListeners();
        Project project = this;
        synchronized (project) {
            if (this.loggingMessage) {
                throw new BuildException("Listener attempted to access " + (priority == 0 ? "System.err" : "System.out") + " - infinite loop terminated");
            }
            this.loggingMessage = true;
            int i = 0;
            while (i < listeners.size()) {
                BuildListener listener = (BuildListener)listeners.elementAt(i);
                listener.messageLogged(event);
                ++i;
            }
            this.loggingMessage = false;
        }
    }

    protected void fireMessageLogged(Project project, String message, int priority) {
        BuildEvent event = new BuildEvent(project);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Target target, String message, int priority) {
        BuildEvent event = new BuildEvent(target);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Task task, String message, int priority) {
        BuildEvent event = new BuildEvent(task);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    public synchronized void registerThreadTask(Thread thread, Task task) {
        if (task != null) {
            this.threadTasks.put(thread, task);
        } else {
            this.threadTasks.remove(thread);
        }
    }

    public Task getThreadTask(Thread thread) {
        return (Task)this.threadTasks.get(thread);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

