/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.core.ArgTagParent;
import org.apache.commons.jelly.tags.core.BaseClassLoaderTag;

public class ArgTag
extends BaseClassLoaderTag {
    private String typeString;
    private Object value;
    private static Map converterMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$core$ArgTagParent;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public void setType(String type) {
        this.typeString = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        ArgTagParent parent;
        this.invokeBody(output);
        Class klass = null;
        if ("boolean".equals(this.typeString)) {
            klass = Boolean.TYPE;
            this.assertNotNull(this.value);
        } else if ("byte".equals(this.typeString)) {
            klass = Byte.TYPE;
            this.assertNotNull(this.value);
        } else if ("short".equals(this.typeString)) {
            klass = Short.TYPE;
            this.assertNotNull(this.value);
        } else if ("int".equals(this.typeString)) {
            klass = Integer.TYPE;
            this.assertNotNull(this.value);
        } else if ("char".equals(this.typeString)) {
            klass = Character.TYPE;
            this.assertNotNull(this.value);
        } else if ("float".equals(this.typeString)) {
            klass = Float.TYPE;
            this.assertNotNull(this.value);
        } else if ("long".equals(this.typeString)) {
            klass = Long.TYPE;
            this.assertNotNull(this.value);
        } else if ("double".equals(this.typeString)) {
            klass = Double.TYPE;
            this.assertNotNull(this.value);
        } else if (null != this.typeString) {
            try {
                klass = this.getClassLoader().loadClass(this.typeString);
            }
            catch (ClassNotFoundException e) {
                throw new JellyTagException(e);
            }
        } else {
            klass = null == this.value ? (class$java$lang$Object == null ? (class$java$lang$Object = ArgTag.class$("java.lang.Object")) : class$java$lang$Object) : this.value.getClass();
        }
        if (!this.isInstanceOf(klass, this.value)) {
            this.value = ArgTag.convert(klass, this.value);
        }
        if (null == (parent = (ArgTagParent)((Object)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$core$ArgTagParent == null ? (class$org$apache$commons$jelly$tags$core$ArgTagParent = ArgTag.class$("org.apache.commons.jelly.tags.core.ArgTagParent")) : class$org$apache$commons$jelly$tags$core$ArgTagParent)))) {
            throw new JellyTagException("This tag must be enclosed inside an ArgTagParent implementation (for example, <new> or <invoke>)");
        }
        parent.addArgument(klass, this.value);
    }

    private void assertNotNull(Object value) throws JellyTagException {
        if (null == value) {
            throw new JellyTagException("A " + this.typeString + " instance cannot be null.");
        }
    }

    private boolean isInstanceOf(Class klass, Object value) {
        return null == value || klass.isInstance(value);
    }

    private static Object convert(Class klass, Object value) throws JellyTagException {
        if (null == value) {
            return null;
        }
        if (!klass.isInstance(value)) {
            Converter converter = (Converter)converterMap.get(klass);
            if (null == converter) {
                throw new JellyTagException("Can't convert " + value + " to " + klass);
            }
            try {
                return converter.convert(klass, value);
            }
            catch (ConversionException e) {
                throw new JellyTagException("Can't convert " + value + " to " + klass + " (" + e.toString() + ")", e);
            }
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Object c = new BooleanConverter();
        converterMap.put(Boolean.TYPE, c);
        converterMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ArgTag.class$("java.lang.Boolean")) : class$java$lang$Boolean, c);
        c = new CharacterConverter();
        converterMap.put(Character.TYPE, c);
        converterMap.put(class$java$lang$Character == null ? (class$java$lang$Character = ArgTag.class$("java.lang.Character")) : class$java$lang$Character, c);
        c = new Converter(){
            private Converter inner = new ByteConverter();

            public Object convert(Class klass, Object value) {
                if (value instanceof Number) {
                    return new Byte(((Number)value).byteValue());
                }
                return this.inner.convert(klass, value);
            }
        };
        converterMap.put(Byte.TYPE, c);
        converterMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ArgTag.class$("java.lang.Byte")) : class$java$lang$Byte, c);
        c = new Converter(){
            private Converter inner = new ShortConverter();

            public Object convert(Class klass, Object value) {
                if (value instanceof Number) {
                    return new Short(((Number)value).shortValue());
                }
                return this.inner.convert(klass, value);
            }
        };
        converterMap.put(Short.TYPE, c);
        converterMap.put(class$java$lang$Short == null ? (class$java$lang$Short = ArgTag.class$("java.lang.Short")) : class$java$lang$Short, c);
        c = new Converter(){
            private Converter inner = new IntegerConverter();

            public Object convert(Class klass, Object value) {
                if (value instanceof Number) {
                    return new Integer(((Number)value).intValue());
                }
                return this.inner.convert(klass, value);
            }
        };
        converterMap.put(Integer.TYPE, c);
        converterMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ArgTag.class$("java.lang.Integer")) : class$java$lang$Integer, c);
        c = new Converter(){
            private Converter inner = new LongConverter();

            public Object convert(Class klass, Object value) {
                if (value instanceof Number) {
                    return new Long(((Number)value).longValue());
                }
                return this.inner.convert(klass, value);
            }
        };
        converterMap.put(Long.TYPE, c);
        converterMap.put(class$java$lang$Long == null ? (class$java$lang$Long = ArgTag.class$("java.lang.Long")) : class$java$lang$Long, c);
        c = new Converter(){
            private Converter inner = new FloatConverter();

            public Object convert(Class klass, Object value) {
                if (value instanceof Number) {
                    return new Float(((Number)value).floatValue());
                }
                return this.inner.convert(klass, value);
            }
        };
        converterMap.put(Float.TYPE, c);
        converterMap.put(class$java$lang$Float == null ? (class$java$lang$Float = ArgTag.class$("java.lang.Float")) : class$java$lang$Float, c);
        c = new Converter(){
            private Converter inner = new DoubleConverter();

            public Object convert(Class klass, Object value) {
                if (value instanceof Number) {
                    return new Double(((Number)value).doubleValue());
                }
                return this.inner.convert(klass, value);
            }
        };
        converterMap.put(Double.TYPE, c);
        converterMap.put(class$java$lang$Double == null ? (class$java$lang$Double = ArgTag.class$("java.lang.Double")) : class$java$lang$Double, c);
    }
}

