/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.simian;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.jelly.JellyContext;
import org.apache.maven.simian.Duplication;
import org.apache.maven.simian.DuplicationArea;

public class SimianLog {
    private File logFile;
    private JellyContext jellyContext;
    private Duplication[] duplications;
    private String copyright1;
    private String copyright2;
    private int totalDuplicateLineCount;
    private int loc;
    private int fileParseCount;
    private String time;
    private int blockCount;
    private int fileWithDuplicateCount;
    private String sourceDirectory;
    private String unitTestSourceDirectory;

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public void setJellyContext(JellyContext jellyContext) {
        this.jellyContext = jellyContext;
    }

    public void setSourceDirectory(String sourceDirectory) throws IOException {
        this.sourceDirectory = new File(sourceDirectory).getCanonicalPath();
    }

    public void setUnitTestSourceDirectory(String unitTestSourceDirectory) throws IOException {
        this.unitTestSourceDirectory = new File(unitTestSourceDirectory).getCanonicalPath();
    }

    public Duplication[] getDuplications() {
        return this.duplications;
    }

    public String getCopyright1() {
        return this.copyright1;
    }

    public String getCopyright2() {
        return this.copyright2;
    }

    private String linkify(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, " ", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("http://")) {
                token = "<a href=\"" + token + "\">" + token + "</a>";
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public int getTotalDuplicateLineCount() {
        return this.totalDuplicateLineCount;
    }

    public int getLoc() {
        return this.loc;
    }

    public int getFileParseCount() {
        return this.fileParseCount;
    }

    public String getTime() {
        return this.time;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getFileWithDuplicateCount() {
        return this.fileWithDuplicateCount;
    }

    public void process() throws IOException {
        String line;
        ArrayList<Duplication> duplicationList = new ArrayList<Duplication>();
        Duplication duplication = null;
        BufferedReader logReader = new BufferedReader(new FileReader(this.logFile));
        this.copyright1 = logReader.readLine();
        this.copyright2 = logReader.readLine();
        while ((line = logReader.readLine()) != null) {
            StringTokenizer summaryTokenizer;
            if (line.endsWith("duplicate lines in the following files:")) {
                StringTokenizer dupeTokenizer = new StringTokenizer(line);
                dupeTokenizer.nextToken();
                int dupeSize = Integer.parseInt(dupeTokenizer.nextToken());
                duplication = new Duplication(dupeSize);
                duplicationList.add(duplication);
                continue;
            }
            if (line.startsWith(" Between")) {
                StringTokenizer dupeEntryTokenizer = new StringTokenizer(line);
                dupeEntryTokenizer.nextToken();
                dupeEntryTokenizer.nextToken();
                int startLine = Integer.parseInt(dupeEntryTokenizer.nextToken());
                dupeEntryTokenizer.nextToken();
                int endLine = Integer.parseInt(dupeEntryTokenizer.nextToken());
                dupeEntryTokenizer.nextToken();
                StringBuffer filePathBuffer = new StringBuffer();
                while (dupeEntryTokenizer.hasMoreTokens()) {
                    filePathBuffer.append(dupeEntryTokenizer.nextToken());
                    filePathBuffer.append(' ');
                }
                String filePath = filePathBuffer.toString();
                String pathToClass = null;
                if (filePath.startsWith(this.sourceDirectory)) {
                    pathToClass = "xref/" + this.getPathToClass(this.sourceDirectory, filePath);
                } else if (filePath.startsWith(this.unitTestSourceDirectory)) {
                    pathToClass = "xref-test/" + this.getPathToClass(this.unitTestSourceDirectory, filePath);
                } else {
                    throw new IllegalStateException("Couldn't find relative path for " + filePath + " in " + this.sourceDirectory + " or " + this.unitTestSourceDirectory);
                }
                DuplicationArea duplicationArea = new DuplicationArea(startLine, endLine, pathToClass, this.getPathToClass(this.sourceDirectory, filePath).replace('/', '.'));
                duplication.addDuplicationArea(duplicationArea);
                continue;
            }
            if (line.indexOf("duplicate lines of code in") != -1) {
                summaryTokenizer = new StringTokenizer(line);
                summaryTokenizer.nextToken();
                this.totalDuplicateLineCount = Integer.parseInt(summaryTokenizer.nextToken());
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                this.blockCount = Integer.parseInt(summaryTokenizer.nextToken());
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                this.fileWithDuplicateCount = Integer.parseInt(summaryTokenizer.nextToken());
                continue;
            }
            if (line.startsWith("Processed a total of")) {
                summaryTokenizer = new StringTokenizer(line);
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                this.loc = Integer.parseInt(summaryTokenizer.nextToken());
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                summaryTokenizer.nextToken();
                this.fileParseCount = Integer.parseInt(summaryTokenizer.nextToken());
                continue;
            }
            if (!line.startsWith("Processing time:")) continue;
            summaryTokenizer = new StringTokenizer(line);
            summaryTokenizer.nextToken();
            summaryTokenizer.nextToken();
            this.time = summaryTokenizer.nextToken();
        }
        this.duplications = duplicationList.toArray(new Duplication[duplicationList.size()]);
        this.jellyContext.setVariable("simianLog", (Object)this);
    }

    private String getPathToClass(String directory, String filePath) {
        int classStart = directory.length() + 1;
        int classEnd = filePath.lastIndexOf(".java");
        String result = filePath.substring(classStart, classEnd).replace(File.separatorChar, '/');
        return result;
    }
}

