/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Label;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.View;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.starteam.StarTeamTask;

public abstract class TreeBasedTask
extends StarTeamTask {
    public static final String DEFAULT_INCLUDESETTING = "*";
    public static final String DEFAULT_EXCLUDESETTING = null;
    private String rootStarteamFolder = "/";
    private String rootLocalFolder = null;
    private String includes = "*";
    private String excludes = DEFAULT_EXCLUDESETTING;
    private String label = null;
    private boolean recursive = true;
    private boolean forced = false;
    private Label labelInUse = null;

    public void setRootStarteamFolder(String rootStarteamFolder) {
        this.rootStarteamFolder = rootStarteamFolder;
    }

    public String getRootStarteamFolder() {
        return this.rootStarteamFolder;
    }

    public void setRootLocalFolder(String rootLocalFolder) {
        this.rootLocalFolder = rootLocalFolder;
    }

    public String getRootLocalFolder() {
        return this.rootLocalFolder;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    protected void logIncludes() {
        if (DEFAULT_INCLUDESETTING != this.includes) {
            this.log("  Includes specified: " + this.includes);
        }
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    protected void logExcludes() {
        if (DEFAULT_EXCLUDESETTING != this.excludes) {
            this.log("  Excludes specified: " + this.excludes);
        }
    }

    protected void _setLabel(String label) {
        if (null != label && (label = label.trim()).length() > 0) {
            this.label = label;
        }
    }

    protected String getLabel() {
        return this.label;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean v) {
        this.recursive = v;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean v) {
        this.forced = v;
    }

    protected boolean isUsingViewLabel() {
        return null != this.labelInUse && this.labelInUse.isViewLabel();
    }

    protected boolean isUsingRevisionLabel() {
        return null != this.labelInUse && this.labelInUse.isRevisionLabel();
    }

    protected Label getLabelInUse() {
        return this.labelInUse;
    }

    protected void logLabel() {
        if (this.isUsingViewLabel()) {
            this.log("  Using view label " + this.getLabel());
        } else if (this.isUsingRevisionLabel()) {
            this.log("  Using revision label " + this.getLabel());
        }
    }

    protected boolean shouldProcess(String pName) {
        boolean includeIt = this.matchPatterns(this.getIncludes(), pName);
        boolean excludeIt = this.matchPatterns(this.getExcludes(), pName);
        return includeIt && !excludeIt;
    }

    protected boolean matchPatterns(String patterns, String pName) {
        if (patterns == null) {
            return false;
        }
        StringTokenizer exStr = new StringTokenizer(patterns, ",");
        while (exStr.hasMoreTokens()) {
            if (!DirectoryScanner.match((String)exStr.nextToken(), (String)pName)) continue;
            return true;
        }
        return false;
    }

    private final Folder configureRootStarteamFolder() throws BuildException {
        Folder starteamrootfolder = null;
        try {
            View snapshot = this.openView();
            starteamrootfolder = StarTeamFinder.findFolder((Folder)snapshot.getRootFolder(), (String)this.rootStarteamFolder);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException("Unable to find root folder " + this.rootStarteamFolder + " in repository at " + this.getURL(), (Throwable)e);
        }
        if (null == starteamrootfolder) {
            throw new BuildException("Unable to find root folder " + this.rootStarteamFolder + " in repository at " + this.getURL());
        }
        return starteamrootfolder;
    }

    private final File getLocalRootMapping(Folder starteamrootfolder) {
        String localrootfolder = null != this.rootLocalFolder ? this.rootLocalFolder : starteamrootfolder.getPathFragment();
        return new File(localrootfolder);
    }

    protected abstract void logOperationDescription(Folder var1, File var2);

    public final void execute() throws BuildException {
        try {
            Folder starteamrootfolder = this.configureRootStarteamFolder();
            File localrootfolder = this.getLocalRootMapping(starteamrootfolder);
            this.testPreconditions();
            this.logOperationDescription(starteamrootfolder, localrootfolder);
            this.visit(starteamrootfolder, localrootfolder);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void findLabel(View v) throws BuildException {
        Label[] allLabels = v.getLabels();
        int i = 0;
        while (i < allLabels.length) {
            Label stLabel = allLabels[i];
            this.log("checking label " + stLabel.getName(), 4);
            if (stLabel != null && !stLabel.isDeleted() && stLabel.getName().equals(this.label)) {
                if (!stLabel.isRevisionLabel() && !stLabel.isViewLabel()) {
                    throw new BuildException("Unexpected label type.");
                }
                this.log("using label " + stLabel.getName(), 4);
                this.labelInUse = stLabel;
                return;
            }
            ++i;
        }
        throw new BuildException("Error: label " + this.label + " does not exist in view " + v.getFullName());
    }

    protected int getLabelID(View v) throws BuildException {
        if (null != this.label) {
            this.findLabel(v);
            return this.labelInUse.getID();
        }
        return -1;
    }

    protected int getIDofLabelInUse() {
        if (null != this.labelInUse) {
            return this.labelInUse.getID();
        }
        return -1;
    }

    protected abstract void visit(Folder var1, File var2) throws BuildException;

    protected abstract void testPreconditions() throws BuildException;

    public static String getFullRepositoryPath(com.starbase.starteam.File remotefile) {
        StringBuffer sb = new StringBuffer();
        sb.append(remotefile.getParentFolderHierarchy()).append(remotefile.getName());
        return sb.toString();
    }

    protected abstract class UnmatchedFileMap
    extends Hashtable {
        protected UnmatchedFileMap() {
        }

        UnmatchedFileMap init(File localFolder, Folder remoteFolder) {
            if (!localFolder.exists()) {
                return this;
            }
            String[] localFiles = localFolder.list();
            int i = 0;
            while (i < localFiles.length) {
                String fn = localFiles[i];
                File localFile = new File(localFolder, localFiles[i]).getAbsoluteFile();
                TreeBasedTask.this.log("adding " + localFile + " to UnmatchedFileMap", 4);
                if (localFile.isDirectory()) {
                    this.put(localFile, new Folder(remoteFolder, fn, fn));
                } else {
                    com.starbase.starteam.File remoteFile = new com.starbase.starteam.File(remoteFolder);
                    remoteFile.setName(fn);
                    this.put(localFile, remoteFile);
                }
                ++i;
            }
            return this;
        }

        void removeControlledItem(File localFile) {
            if (this.isActive()) {
                TreeBasedTask.this.log("removing processed " + localFile.getAbsoluteFile() + " from UnmatchedFileMap", 4);
                this.remove(localFile.getAbsoluteFile());
            }
        }

        abstract void processUncontrolledItems() throws BuildException;

        protected abstract boolean isActive();
    }
}

