/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class XMLValidateTask
extends Task {
    protected static String INIT_FAILED_MSG = "Could not start xml validation: ";
    protected boolean failOnError = true;
    protected boolean warn = true;
    protected boolean lenient = false;
    protected String readerClassName = null;
    protected File file = null;
    protected Vector filesets = new Vector();
    protected Path classpath;
    protected XMLReader xmlReader = null;
    protected ValidatorErrorHandler errorHandler = new ValidatorErrorHandler();
    protected Hashtable features = new Hashtable();
    private XMLCatalog xmlCatalog = new XMLCatalog();

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setWarn(boolean bool) {
        this.warn = bool;
    }

    public void setLenient(boolean bool) {
        this.lenient = bool;
    }

    public void setClassName(String className) {
        this.readerClassName = className;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(catalog);
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(((ProjectComponent)this).project);
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLocation = new DTDLocation();
        this.xmlCatalog.addDTD(dtdLocation);
        return dtdLocation;
    }

    protected EntityResolver getEntityResolver() {
        return this.xmlCatalog;
    }

    public void execute() throws BuildException {
        int fileProcessed = 0;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        this.initValidator();
        if (this.file != null) {
            if (this.file.exists() && this.file.canRead() && this.file.isFile()) {
                this.doValidate(this.file);
                ++fileProcessed;
            } else {
                String errorMsg = "File " + this.file + " cannot be read";
                if (this.failOnError) {
                    throw new BuildException(errorMsg);
                }
                this.log(errorMsg, 0);
            }
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            String[] files = ds.getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                File srcFile = new File(fs.getDir(((ProjectComponent)this).project), files[j]);
                this.doValidate(srcFile);
                ++fileProcessed;
                ++j;
            }
            ++i;
        }
        this.log(fileProcessed + " file(s) have been successfully validated.");
    }

    private void initValidator() {
        Object reader = null;
        if (this.readerClassName == null) {
            try {
                reader = JAXPUtils.getXMLReader();
            }
            catch (BuildException exc) {
                reader = JAXPUtils.getParser();
            }
        } else {
            Class<?> readerClass = null;
            try {
                if (this.classpath != null) {
                    AntClassLoader loader = new AntClassLoader(((ProjectComponent)this).project, this.classpath);
                    readerClass = loader.loadClass(this.readerClassName);
                    AntClassLoader.initializeClass(readerClass);
                } else {
                    readerClass = Class.forName(this.readerClassName);
                }
                reader = readerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new BuildException(INIT_FAILED_MSG + this.readerClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new BuildException(INIT_FAILED_MSG + this.readerClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BuildException(INIT_FAILED_MSG + this.readerClassName, (Throwable)e);
            }
        }
        if (reader instanceof XMLReader) {
            this.xmlReader = (XMLReader)reader;
            this.log("Using SAX2 reader " + reader.getClass().getName(), 3);
        } else if (reader instanceof Parser) {
            this.xmlReader = new ParserAdapter((Parser)reader);
            this.log("Using SAX1 parser " + reader.getClass().getName(), 3);
        } else {
            throw new BuildException(INIT_FAILED_MSG + this.readerClassName + " implements nor SAX1 Parser nor SAX2 XMLReader.");
        }
        this.xmlReader.setEntityResolver(this.getEntityResolver());
        this.xmlReader.setErrorHandler(this.errorHandler);
        if (!(this.xmlReader instanceof ParserAdapter)) {
            boolean ok;
            if (!this.lenient && !(ok = this.setFeature("http://xml.org/sax/features/validation", true, true))) {
                throw new BuildException(INIT_FAILED_MSG + this.readerClassName + " doesn't provide validation");
            }
            Enumeration enumeration = this.features.keys();
            while (enumeration.hasMoreElements()) {
                String featureId = (String)enumeration.nextElement();
                this.setFeature(featureId, (Boolean)this.features.get(featureId), true);
            }
        }
    }

    private boolean setFeature(String feature, boolean value, boolean warn) {
        boolean toReturn;
        block4: {
            toReturn = false;
            try {
                this.xmlReader.setFeature(feature, value);
                toReturn = true;
            }
            catch (SAXNotRecognizedException e) {
                if (warn) {
                    this.log("Could not set feature '" + feature + "' because the parser doesn't recognize it", 1);
                }
            }
            catch (SAXNotSupportedException e) {
                if (!warn) break block4;
                this.log("Could not set feature '" + feature + "' because the parser doesn't support it", 1);
            }
        }
        return toReturn;
    }

    private void doValidate(File afile) {
        try {
            this.log("Validating " + afile.getName() + "... ", 3);
            this.errorHandler.init(afile);
            InputSource is = new InputSource(new FileInputStream(afile));
            String uri = "file:" + afile.getAbsolutePath().replace('\\', '/');
            int index = uri.indexOf(35);
            while (index != -1) {
                uri = uri.substring(0, index) + "%23" + uri.substring(index + 1);
                index = uri.indexOf(35);
            }
            is.setSystemId(uri);
            this.xmlReader.parse(is);
        }
        catch (SAXException ex) {
            if (this.failOnError) {
                throw new BuildException("Could not validate document " + afile);
            }
        }
        catch (IOException ex) {
            throw new BuildException("Could not validate document " + afile, (Throwable)ex);
        }
        if (this.errorHandler.getFailure()) {
            if (this.failOnError) {
                throw new BuildException(afile + " is not a valid XML document.");
            }
            this.log(afile + " is not a valid XML document", 0);
        }
    }

    protected class ValidatorErrorHandler
    implements ErrorHandler {
        protected File currentFile = null;
        protected String lastErrorMessage = null;
        protected boolean failed = false;

        protected ValidatorErrorHandler() {
        }

        public void init(File file) {
            this.currentFile = file;
            this.failed = false;
        }

        public boolean getFailure() {
            return this.failed;
        }

        public void fatalError(SAXParseException exception) {
            this.failed = true;
            this.doLog(exception, 0);
        }

        public void error(SAXParseException exception) {
            this.failed = true;
            this.doLog(exception, 0);
        }

        public void warning(SAXParseException exception) {
            if (XMLValidateTask.this.warn) {
                this.doLog(exception, 1);
            }
        }

        private void doLog(SAXParseException e, int logLevel) {
            XMLValidateTask.this.log(this.getMessage(e), logLevel);
        }

        private String getMessage(SAXParseException e) {
            String sysID = e.getSystemId();
            if (sysID != null) {
                try {
                    int line = e.getLineNumber();
                    int col = e.getColumnNumber();
                    return new URL(sysID).getFile() + (line == -1 ? "" : ":" + line + (col == -1 ? "" : ":" + col)) + ": " + e.getMessage();
                }
                catch (MalformedURLException mfue) {
                }
            }
            return e.getMessage();
        }
    }
}

