/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;

public class NavBean {
    private String location;
    private Node document;

    public void setDocument(Object o) {
        this.document = (Node)o;
    }

    private static String getAttribute(DefaultElement elem, String attribute, String defaultValue) {
        Attribute attr = elem.attribute(attribute);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getStringValue();
    }

    private static boolean getCollapseAttribute(DefaultElement elem) {
        return Boolean.valueOf(NavBean.getAttribute(elem, "collapse", "false"));
    }

    private static String getHREFAttribute(DefaultElement elem) {
        return NavBean.getAttribute(elem, "href", null);
    }

    public boolean isCollapsed(Object o) {
        if (this.location == null) {
            return true;
        }
        if (!(o instanceof DefaultElement)) {
            System.out.println(o.getClass().getName());
            return false;
        }
        DefaultElement elem = (DefaultElement)o;
        boolean collapsed = NavBean.getCollapseAttribute(elem);
        if (!collapsed) {
            return false;
        }
        if (this.isSelected(o)) {
            return false;
        }
        String xpath = this.location.startsWith("/") || this.location.startsWith(".") ? ".//item[@href='" + this.location + "']" : ".//item[@href='/" + this.location + "']";
        List l = elem.selectNodes(xpath);
        return l.size() == 0;
    }

    public boolean isSelected(Object o) {
        if (this.location == null) {
            return false;
        }
        DefaultElement elem = (DefaultElement)o;
        return this.location.equals(NavBean.getHREFAttribute(elem));
    }

    public void setLocation(String location) {
        if (!location.startsWith("/")) {
            location = "/" + location;
        }
        this.location = location;
    }

    public DefaultElement getFirstNodeByHREF(String href) {
        String xpath = "//item[@href='" + href + "']";
        return (DefaultElement)this.document.selectSingleNode(xpath);
    }
}

